REGISTER /me/Software/pig/build/ivy/lib/Pig/avro-1.5.3.jar
REGISTER /me/Software/pig/build/ivy/lib/Pig/json-simple-1.1.jar
REGISTER /me/Software/pig/contrib/piggybank/java/piggybank.jar

DEFINE AvroStorage org.apache.pig.piggybank.storage.avro.AvroStorage();

rmf /tmp/from_counts.txt
rmf /tmp/sent_counts.txt
rmf /tmp/from_to_cc_counts.txt

/* Wczytanie wiadomości w formacie avro format (ścieżka powinna się zgadzać z miejscem składowania plików avro) za pomocą AvroStorage UDF z Piggybanku */
messages = LOAD '/me/Data/test_mbox' USING AvroStorage();

/* nie chcemy pustych */
messages = FILTER messages BY (from IS NOT NULL) AND (tos IS NOT NULL);

/* Zliczenie łącznej liczby wiadomości wysłanych spod danego adresu */
just_froms = FOREACH messages GENERATE from.address as from;
from_counts = FOREACH (GROUP just_froms BY from) GENERATE group as from, COUNT_STAR(just_froms) as total;
STORE from_counts INTO '/tmp/from_counts.txt';

/* Wiadomości e-mail mogą mieć wielu adresatów. FLATTEN() wykona projekcję na pary nadawca-odbiorca dla wszystkich odbiorców. */
addresses = FOREACH messages GENERATE from.address AS from, 
                                      FLATTEN(tos.(address)) AS to;

/* Adres e-mail lepiej zapisać małymi literami, żeby omyłkowo nie zliczać takuch samych, ale inaczej zapisanych adresów */
lowercase_addresses = FOREACH addresses GENERATE LOWER(from) AS from, 
                                    LOWER(to) AS to;

/* GROUP BY według par from-to do tablicy, potem zliczenie zawartości tablicy ($1 oznacza drugie pole).
   To samo, co w SQL: SELECT from, to, COUNT(*) FROM lowers GROUP BY (from, to);
   UWAGA: COUNT_STAR różni się od COUNT tym, że zlicza też wpisy puste. */
by_from_to = GROUP lowercase_addresses BY (from, to);
sent_counts = FOREACH by_from_to GENERATE 
                FLATTEN(group) AS (from, to), 
                COUNT_STAR(lowercase_addresses) AS total;

/* Sortowanie danych, od największej liczby wysłanych wiadomości */
sent_counts = ORDER sent_counts BY total DESC;
STORE sent_counts INTO '/tmp/sent_counts.txt';

/* Podzielenie wiadomości na te, które mają adresatów i odbiorców kopii */
to_ccs = FILTER messages BY (from IS NOT NULL) AND (tos IS NOT NULL) AND (ccs IS NOT NULL);

/* Projekcja wszystkich unikatowych kombinacji nadawców, adresatów i odbiorców kopii. */
from_to_cc = FOREACH to_ccs GENERATE from.address AS from, 
                                    FLATTEN(tos.(address)) AS to,
                                    FLATTEN(ccs.(address)) AS cc;
                                    
/* Znów zamiana na małe litery */
lower_from_to_cc = FOREACH from_to_cc GENERATE 
                                      LOWER(from) as from,
                                      LOWER(to) as to,
                                      LOWER(cc) as cc;

/* A teraz grupowanie i zliczanie */
from_to_cc_counts = FOREACH (GROUP lower_from_to_cc BY (from, to, cc)) GENERATE FLATTEN(group) AS (from, to, cc), 
                                                                       COUNT_STAR(lower_from_to_cc) AS total;
/* Sortowanie, od największej liczności do najmniejszej */
from_to_cc_counts = ORDER from_to_cc_counts BY total DESC;
                                                                       
STORE from_to_cc_counts INTO '/tmp/from_to_cc_counts.txt';
