var Person = {
  firstName : 'Jan',
  lastName : 'Kowalski',
  birthDate : new Date( '1964-09-05' ),
  gender : 'mężczyzna',
  getAge : function () {
    var today = new Date();
    var diff = today.getTime() - this.birthDate.getTime();
    var year = 1000 * 60 * 60 * 24 * 365.25;
    return Math.floor( diff / year );
  },
  toString : function () {
    return this.firstName + ' ' + this.lastName + ' ma ' + this.getAge() +
     ' lat ' + this.gender;
  },
  extend : function ( config ) {
    var tmp = Object.create( this );
    for ( var key in config ) {
      if ( config.hasOwnProperty( key ) ) {
        tmp[key] = config[key];
      }
    }
    return tmp;
  }
};
var bob = Person.extend( {
  firstName : 'Bob',
  lastName : 'Nowak',
  birthDate : new Date( '1969-06-07' )
} );
console.log( bob.toString() );

