# -*- coding: utf-8 -*-
import RPi.GPIO as GPIO
import time

GPIO.setmode(GPIO.BCM)

step_pin = 24
dir_pin = 25
ms1_pin = 23
ms2_pin = 18

GPIO.setup(step_pin, GPIO.OUT)
GPIO.setup(dir_pin, GPIO.OUT)
GPIO.setup(ms1_pin, GPIO.OUT)
GPIO.setup(ms2_pin, GPIO.OUT)

period = 0.02

def step(steps, direction, period):  # (1)
  GPIO.output(dir_pin, direction)  
  for i in range(0, steps):
    GPIO.output(step_pin, True)
    time.sleep(0.000002)
    GPIO.output(step_pin, False)
    time.sleep(period)

def step_mode(mode):                 # (2)
    GPIO.output(ms1_pin, mode & 1)   # (3)
    GPIO.output(ms2_pin, mode & 2)

try:
    print('Polecenie w formie litery oraz liczby');
    print('p20 - 20 ms przerwy pomiędzy kolejnymi krokami (prędkość obrotowa)');
    print('m - tryb mikro kroków (0-brak 1-połowa, 2-ćwierć, 3-jedna ósma)');
    print('f100 - 100 kroków w przód');
    print('r100 - 100 kroków w tył');
    
    while True:                       # (4)
        command = raw_input('Wprowadź polecenie: ')
        parameter_str = command[1:] # od znaku nr 1 do końca
        parameter = int(parameter_str)
        if command[0] == 'p':
            period = parameter / 1000.0
        elif command[0] == 'm':
            step_mode(parameter)
        elif command[0] == 'f':
            step(parameter, True, period)
        elif command[0] == 'r':
            step(parameter, False, period)

finally:
    print('Czyszczenie')
    GPIO.cleanup()