function backgroundReadFile(url, callback) {
  var req = new XMLHttpRequest();
  req.open("GET", url, true);
  req.addEventListener("load", function() {
    if (req.status < 400)
      callback(req.responseText);
  });
  req.send(null);
}

function getURL(url, callback) {
  var req = new XMLHttpRequest();
  req.open("GET", url, true);
  req.addEventListener("load", function() {
    if (req.status < 400)
      callback(req.responseText);
    else
      callback(null, new Error("Żądanie nie powiodło się: " +
                               req.statusText));
  });
  req.addEventListener("error", function() {
    callback(null, new Error("Błąd sieci."));
  });
  req.send(null);
}

function get(url) {
  return new Promise(function(succeed, fail) {
    var req = new XMLHttpRequest();
    req.open("GET", url, true);
    req.addEventListener("load", function() {
      if (req.status < 400)
        succeed(req.responseText);
      else
        fail(new Error("Żądanie nie powiodło się: " + req.statusText));
    });
    req.addEventListener("error", function() {
      fail(new Error("Błąd sieci."));
    });
    req.send(null);
  });
}

function getJSON(url) {
  return get(url).then(JSON.parse);
}
