(function() {
  const connections = [
    "Wiea kocielna-Boisko", "Wiea kocielna-Duy klon", "Duy klon-Boisko",
    "Duy klon-Las", "Duy klon-Ogrd Fabienne", "Ogrd Fabienne-Las",
    "Ogrd Fabienne-Pastwisko", "Pastwisko-Duy db", "Duy db-Rzenia",
    "Rzenia-Wysoka topola", "Wysoka topola-Boisko", "Wysoka topola-Paac",
    "Paac-Dua sosna", "Dua sosna-Gospodarstw Jacques'a", "Gospodarstw Jacques'a-Gg",
    "Dua sosna-Gg", "Gg-Ogrd Gillesa", "Dua sosna-Ogrd Gillesa",
    "Ogrd Gillesa-Duy db", "Ogrd Gillesa-Rzenia", "Paac-Rzenia"
  ]

  function storageFor(name) {
    let storage = Object.create(null)
    storage["schowki na jedzenie"] = ["schowek w dbie", "schowek na ce", "schowek pod ywopotem"]
    storage["schowek w dbie"] = "Dziura na trzeci du gazi od dou. Kilka kawakw chleba i troch szyszek."
    storage["shcowek na ce"] = "Zakopany pod pokrzywami (strona poudniowa). Zdechy w."
    storage["schowek pod ywopotem"] = "rodek ywopotu w ogrodzie Gillesa. Oznaczony rozgazionym patykiem. Dwie butelki piwa."
    storage["wrogowie"] = ["Pies Jacques'a", "Rzenik", "Ta jednonoga kawka", "Chopiec z wiatrwk"]
    if (name == "Wiea kocielna" || name == "Gg" || name == "Paac")
      storage["events on 2017-12-21"] = "Gboki nieg. mieci rzenika mog si przewrci. Przegonilimy kruki z Saint-Vulbas."
    let hash = 0
    for (let i = 0; i < name.length; i++) hash += name.charCodeAt(i)
    for (let y = 1985; y <= 2018; y++) {
      storage[`chicks in ${y}`] = hash % 6
      hash = Math.abs((hash << 2) ^ (hash + y))
    }
    if (name == "Duy db") storage.scalpel = "Ogrd Gillesa"
    else if (name == "Ogrd Gillesa") storage.scalpel = "Las"
    else if (name == "Woods") storage.scalpel = "Paac"
    else if (name == "Paac" || name == "Rzenia") storage.scalpel = "Rzenia"
    else storage.scalpel = "Duy db"
    for (let prop of Object.keys(storage)) storage[prop] = JSON.stringify(storage[prop])
    return storage
  }

  class Network {
    constructor(connections, storageFor) {
      let reachable = Object.create(null)
      for (let [from, to] of connections.map(conn => conn.split("-"))) {
        ;(reachable[from] || (reachable[from] = [])).push(to)
        ;(reachable[to] || (reachable[to] = [])).push(from)
      }
      this.nodes = Object.create(null)
      for (let name of Object.keys(reachable))
        this.nodes[name] = new Node(name, reachable[name], this, storageFor(name))
      this.types = Object.create(null)
    }

    defineRequestType(name, handler) {
      this.types[name] = handler
    }

    everywhere(f) {
      for (let node of Object.values(this.nodes)) f(node)
    }
  }

  const $storage = Symbol("storage"), $network = Symbol("network")

  function ser(value) {
    return value == null ? null : JSON.parse(JSON.stringify(value))
  }

  class Node {
    constructor(name, neighbors, network, storage) {
      this.name = name
      this.neighbors = neighbors
      this[$network] = network
      this.state = Object.create(null)
      this[$storage] = storage
    }

    send(to, type, message, callback) {
      let toNode = this[$network].nodes[to]
      if (!toNode || !this.neighbors.includes(to))
        return callback(new Error(`Nie ma dostpu do ${to} z ${this.name}`))
      let handler = this[$network].types[type]
      if (!handler)
        return callback(new Error("Nieznany typ dania " + type))
      if (Math.random() > 0.03) setTimeout(() => {
        try {
          handler(toNode, ser(message), this.name, (error, response) => {
            setTimeout(() => callback(error, ser(response)), 10)
          })
        } catch(e) {
          callback(e)
        }
      }, 10 + Math.floor(Math.random() * 10))
    }

    readStorage(name, callback) {
      let value = this[$storage][name]
      setTimeout(() => callback(value && JSON.parse(value)), 20)
    }

    writeStorage(name, value, callback) {
      setTimeout(() => {
        this[$storage][name] = JSON.stringify(value)
        callback()
      }, 20)
    }
  }

  let network = new Network(connections, storageFor)
  exports.bigOak = network.nodes["Duy db"]
  exports.everywhere = network.everywhere.bind(network)
  exports.defineRequestType = network.defineRequestType.bind(network)

  if (typeof __sandbox != "undefined") {
    __sandbox.handleDeps = false
    __sandbox.notify.onLoad = () => {
      // Sztuczka opniajca wszystkie funkcje a wszystkie wzy
      // podziaaj przez 500 ms, aby da im szans na
      // rozesanie informacji po sieci.
      let waitFor = Date.now() + 500
      function wrapWaiting(f) {
        return function(...args) {
          let wait = waitFor - Date.now()
          if (wait <= 0) return f(...args)
          return new Promise(ok => setTimeout(ok, wait)).then(() => f(...args))
        }
      }
      for (let n of ["routeRequest", "findInStorage", "chicks"])
        window[n] = wrapWaiting(window[n])
    }
  }

  if (typeof window != "undefined") {
    window.require = name => {
      if (name != "./crow-tech") throw new Error("Gniazda wron mog da tylko \"./crow-tech\"")
      return exports
    }
  } else if (typeof module != "undefined" && module.exports) {
    module.exports = exports
  }
})()