SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `filmy` ;
CREATE SCHEMA IF NOT EXISTS `filmy` DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci ;
USE `filmy` ;

-- -----------------------------------------------------
-- Table `filmy`.`film`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `filmy`.`film` (
  `film_id` INT NOT NULL AUTO_INCREMENT ,
  `tytul` VARCHAR(128) NULL ,
  PRIMARY KEY (`film_id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `filmy`.`aktor`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `filmy`.`aktor` (
  `aktor_id` INT NOT NULL AUTO_INCREMENT ,
  `imie` VARCHAR(45) NULL ,
  `nazwisko` VARCHAR(45) NULL ,
  PRIMARY KEY (`aktor_id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `filmy`.`film_has_aktor`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `filmy`.`film_has_aktor` (
  `film_id` INT NOT NULL ,
  `aktor_id` INT NOT NULL ,
  PRIMARY KEY (`film_id`, `aktor_id`) ,
  INDEX `fk_film_has_aktor_film` (`film_id` ASC) ,
  INDEX `fk_film_has_aktor_aktor1` (`aktor_id` ASC) ,
  CONSTRAINT `fk_film_has_aktor_film`
    FOREIGN KEY (`film_id` )
    REFERENCES `filmy`.`film` (`film_id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_film_has_aktor_aktor1`
    FOREIGN KEY (`aktor_id` )
    REFERENCES `filmy`.`aktor` (`aktor_id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;

grant all on filmy.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;

