<?php

class Application_Model_DbTable_Zawodnik extends Zend_Db_Table_Abstract
{
    protected $_name = 'zawodnik';

    protected $_rowClass = 'Application_Model_DbTable_Zawodnik_Row';

    protected $_referenceMap = array(
        'Panstwo' => array(
            'columns'         => array('panstwo_id'),
            'refTableClass'   => 'Application_Model_DbTable_Panstwo',
            'refTableColumns' => array('panstwo_id')
        )
    );

    protected $_dependentTables = array('Application_Model_DbTable_TurniejHasZawodnik');

    public function fetchAll($where = null, $order = null, $count = null, $offset = null)
    {
        if ($where === null) {
            $select = $this->select();
        } else if (!($where instanceof Zend_Db_Table_Select)) {
            $select = $this->select();

            if ($where !== null) {
                $this->_where($select, $where);
            }

            if ($order !== null) {
                $this->_order($select, $order);
            }

            if ($count !== null || $offset !== null) {
                $select->limit($count, $offset);
            }

        } else {
            $select = $where;
        }

        $select->order('nazwisko');

        return parent::fetchAll($select, $order, $count, $offset);
    }

    public function findOneBySlug($slug)
    {
        $select  = $this->select()->where('slug = ?', $slug);
        return $this->fetchRow($select);
    }

    public function insertIfNotExists($data)
    {
        $select = $this->select()
            ->from('zawodnik', array('zawodnik_id'))
            ->where('nazwisko = ?', $data['nazwisko'])
            ->where('imie = ?', $data['imie']);

        if ($zawodnik = $this->fetchRow($select)) {
            return $zawodnik->zawodnik_id;
        }

        return $this->createRow($data)->save();
    }

}