<?php

class Application_Model_DbTable_Kontynent_Row extends Zend_Db_Table_Row
{

    public function __toString()
    {
        return (string)$this->nazwa;
    }

    function getPanstwa()
    {
        $Panstwo = new Application_Model_DbTable_Panstwo();
        $select  = $Panstwo->select()->order('nazwa');
        return $this->findDependentRowset('Application_Model_DbTable_Panstwo', null, $select);
    }

    public function obcePanstwaFetchPairs()
    {
        $sql = 'select panstwo_id, nazwa from panstwo where kontynent_id != ? order by nazwa';
        return $this->getTable()->getAdapter()->fetchPairs($sql, $this->kontynent_id);
    }

    function getPanstwaIds()
    {
        $sql = 'select panstwo_id from panstwo where kontynent_id = ?';
        return $this->
                    getTable()->
                    getAdapter()->
                    fetchCol($sql, $this['kontynent_id']);
    }

    function dodajPanstwa($ids)
    {
        $panstwa = implode(' , ', $ids);
        $sql =
            'update panstwo set kontynent_id = '.
            $this->kontynent_id .
            ' where panstwo_id in ( ' .
            $panstwa .
            ' )';
        $db = $this->getTable()->getAdapter();
        $db->query($sql);
    }

    function usunPanstwa($ids)
    {
        $panstwa = implode(' , ', $ids);
        $sql =
            'update panstwo set kontynent_id = null where panstwo_id in ( ' .
            $panstwa .
            ' )';
        $db = $this->getTable()->getAdapter();
        $db->query($sql);
    }

    function ustalPanstwa($ids)
    {
        if (!is_array($ids)) {
            $ids = array();
        }

        $biezace = $this->getPanstwaIds();

        $do_usuniecia = array_diff($biezace, $ids);
        $do_dodania = array_diff($ids, $biezace);

        if (!empty($do_dodania)) {
            $this->dodajPanstwa($do_dodania);
        }

        if ($do_usuniecia) {
            $this->usunPanstwa($do_usuniecia);
        }
    }



    protected function _insert()
    {
        if ($this->slug === null) {
            $this->setSlug(My_Slugs::string2slug($this->nazwa));
        }
    }

    protected function _update()
    {
        if ($this->slug === null) {
            $this->setSlug(My_Slugs::string2slug($this->nazwa));
        }
    }

    public function setSlug($slug)
    {
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }

        $next_slug = $slug;

        $q = 'select count(kontynent_id) from kontynent where slug = ?';
        $db = $this->_getTable()->getAdapter();
        $ile = $db->fetchOne($q, $next_slug);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 100;

        while (!$unikatowy) {

            $next_slug = $slug . $min;
            $min++;

            if ($min > $max + 1) {
                 throw new Exception("setSlug({$next_slug})");
            };

            $q = 'select count(kontynent_id) from kontynent where slug = ?';
            $db = $this->_getTable()->getAdapter();
            $ile = $db->fetchOne($q, $next_slug);

            $unikatowy = ($ile == 0);
        }

        $this->slug = $next_slug;
    }

}
