<?php

// Define path to application directory
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));

// Define application environment
defined('APPLICATION_ENV')
    || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'development'));

// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    get_include_path(),
)));

/** Zend_Application */
require_once 'Zend/Application.php';

// Create application, bootstrap, and run
$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/application.ini'
);
$application->bootstrap('db');

$Film = new Application_Model_DbTable_Film();
$Aktor = new Application_Model_DbTable_Aktor();
$FilmHasAktor = new Application_Model_DbTable_FilmHasAktor();

$FilmHasAktor->delete('');
$Film->delete('');
$Aktor->delete('');


$xml = simplexml_load_file('../data/filmy.xml');
foreach ($xml->film as $f) {
    $dane = (array) $f;
    try {
        $film_id = $Film->createRow($dane)->save();
    } catch (Zend_Db_Statement_Exception $e) {
        die($e->getMessage());
    }

    foreach ($f->aktorzy->aktor as $aktor) {

        $dane = (array)$aktor;

        try {
            $aktor_id = $Aktor->insertIfNotExists($dane);
        } catch (Zend_Db_Statement_Exception $e) {
            die($e->getMessage());
        }

        $dane = array(
            'film_id' => $film_id,
            'aktor_id' => $aktor_id
        );

        try {
            $FilmHasAktor->createRow($dane)->save();
        } catch (Zend_Db_Statement_Exception $e) {
            die($e->getMessage());
        }

    }

}
