<?php

// Define path to application directory
defined('APPLICATION_PATH')
    || define('APPLICATION_PATH', realpath(dirname(__FILE__) . '/../application'));

// Define application environment
defined('APPLICATION_ENV')
    || define('APPLICATION_ENV', (getenv('APPLICATION_ENV') ? getenv('APPLICATION_ENV') : 'development'));

// Ensure library/ is on include_path
set_include_path(implode(PATH_SEPARATOR, array(
    realpath(APPLICATION_PATH . '/../library'),
    get_include_path(),
)));

/** Zend_Application */
require_once 'Zend/Application.php';

// Create application, bootstrap, and run
$application = new Zend_Application(
    APPLICATION_ENV,
    APPLICATION_PATH . '/configs/application.ini'
);
$application->bootstrap('db');

$Szczyt = new Application_Model_DbTable_Szczyt();

$Szczyt->delete('');

$xml = simplexml_load_file('../data/tatry.xml');
foreach ($xml->szczyt as $szczyt) {
    $dane = (array) $szczyt;
    try {
        $Szczyt->createRow($dane)->save();
    } catch (Zend_Db_Statement_Exception $e) {
        die($e->getMessage());
    }
}
