<?php

class Application_Model_DbTable_Panstwo extends Zend_Db_Table_Abstract
{
    protected $_name = 'panstwo';

    protected $_rowClass = 'Application_Model_DbTable_Panstwo_Row';

    protected $_dependentTables = array('Application_Model_DbTable_Zawodnik');

    public function fetchAll($where = null, $order = null, $count = null, $offset = null)
    {
        if ($where === null) {
            $select = $this->select();
        } else if (!($where instanceof Zend_Db_Table_Select)) {
            $select = $this->select();

            if ($where !== null) {
                $this->_where($select, $where);
            }

            if ($order !== null) {
                $this->_order($select, $order);
            }

            if ($count !== null || $offset !== null) {
                $select->limit($count, $offset);
            }

        } else {
            $select = $where;
        }

        $select->order('nazwa');

        return parent::fetchAll($select, $order, $count, $offset);
    }

    public function insertIfNotExists($data)
    {
        $select = $this->select()
            ->from('panstwo', array('panstwo_id'))
            ->where('nazwa = ?', $data['nazwa']);

        if ($panstwo = $this->fetchRow($select)) {
            return $panstwo->panstwo_id;
        }

        return $this->createRow($data)->save();
    }

    public function findOneBySlug($slug)
    {
        $select  = $this->select()->where('slug = ?', $slug);
        return $this->fetchRow($select);
    }

}