<?php

class Application_Model_DbTable_Artykul_Row extends Zend_Db_Table_Row
{

    protected function _insert()
    {
        if ($this->slug === null) {
            $this->setSlug(My_Slugs::string2slug($this->tytul, array('maxlength' => 10)));
        }
    }

    protected function _update()
    {
        if ($this->slug === null) {
            $this->setSlug(My_Slugs::string2slug($this->tytul, array('maxlength' => 10)));
        }
    }

    public function setSlug($slug)
    {
        if (trim($slug) == '') {
            $slug = 'nieznany';
        }

        $next_slug = $slug;

        $q = 'select count(artykul_id) from artykul where slug = ?';
        $db = $this->_getTable()->getAdapter();
        $ile = $db->fetchOne($q, $next_slug);

        $unikatowy = ($ile == 0);

        $min = 2;
        $max = 100;

        while (!$unikatowy) {

            $next_slug = $slug . $min;
            $min++;

            if ($min > $max + 1) {
                 throw new Exception("setSlug({$next_slug})");
            };

            $q = 'select count(artykul_id) from artykul where slug = ?';
            $db = $this->_getTable()->getAdapter();
            $ile = $db->fetchOne($q, $next_slug);

            $unikatowy = ($ile == 0);
        }

        $this->slug = $next_slug;
    }

}
