<?php

class PanstwoController extends My_Crud_Controller
{

    public function preDispatch()
    {
        $auth = Zend_Auth::getInstance();
        if (!$auth->hasIdentity()) {
            return $this->_helper->redirector(
                'index',
                'auth',
                'default'
            );
        }
        $this->view->identity = $auth->getIdentity();
    }


    public function init()
    {
        $this->_db_table_class = 'Application_Model_DbTable_Panstwo';
        $this->_form_class = 'Application_Form_Panstwo';
    }

    public function showAction()
    {
        $slug = $this->_request->getParam('slug', 'brak');
        $Panstwo = new Application_Model_DbTable_Panstwo();
        $this->view->panstwo = $Panstwo->findOneBySlug($slug);
        if (!$this->view->panstwo) {
            throw new Zend_Controller_Action_Exception(sprintf('PanstwoController/showAction: błędny slug: "%s" ', $slug), 404);
        }
    }

}
