<?php

class Application_Form_Osoba extends Zend_Form
{

    public function init()
    {

        /*
         * Pierwsza metoda tworzenia kontrolek formularza
         * Pierwszy parametr (tj. text) określa klasę Zend_Form_Element_Text
         * Drugi parametr (tj. imie) ustala nazwę kontrolki: imie
         *
         * Kontrolka jest dostępna jako:
         *     $this->imie
         *     $this->getElement('imie')
         */
        $this->addElement('text', 'imie', array('label' => 'Imię:'));


        /*
         * Druga metoda tworzenia kontrolek formularza
         * O rodzaju tworzonej kontrolki decyduje
         * nazwa klasy (tj. Zend_Form_Element_Text)
         * Pierwszy parametr konstruktora (tj. nazwisko) ustala nazwę kontrolki: nazwisko
         *
         * Kontrolka jest dostępna jako:
         *     $this->nazwisko
         *     $this->getElement('nazwisko')
         */
        $kontrolka = new Zend_Form_Element_Text('nazwisko', array('label' => 'Nazwisko:'));
        $this->addElement($kontrolka);


        /*
         * Kontrolka typu Zend_Form_Element_Submit
         * Kontrolka jest dostępna jako:
         *     $this->zatwierdz
         *     $this->getElement('zatwierdz')
         */
        $this->addElement('submit', 'zatwierdz', array('label' => 'Przetwórz formularz'));

        $this->setElementDecorators(
            array(
                'ViewHelper',
                'Errors',
                array('Description', array('tag' => 'p', 'class' => 'description')),
                array('HtmlTag', array('tag' => 'div')),
                array('Label')
            ),
            array(
                'imie',
                'nazwisko',
                'zatwierdz',
            )
        );

    }

}
