<?php

require_once 'XML/Serializer.php';

$serializer = new XML_Serializer();

$options = array(
    'addDecl'        => true,
    'indent'         => '    ',
    'rootName'       => 'wiersze',
    'encoding'       => 'utf-8',
    'defaultTagName' => 'wiersz',
);

$serializer->setOptions($options);

$dane = array();

$plks = glob('txt/*.txt');
shuffle($plks);
foreach ($plks as $k => $plk) {
    $tmp = file($plk);
    $autor = trim($tmp[0]);
    $tmp[0] = '';
    $tytul = trim($tmp[1]);
    $tmp[1] = '';
    $tresc = trim(implode('', $tmp));

    $tmp = array(
        'autor' => $autor,
        'tytul' => $tytul,
        'tresc' => $tresc
    );
    array_push($dane, $tmp);
}

$serializer->serialize($dane);

$wynik = $serializer->getSerializedData();

file_put_contents('wiersze-rozewicza.xml', $wynik);



