SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='TRADITIONAL';

DROP SCHEMA IF EXISTS `mojeksiazki` ;
CREATE SCHEMA IF NOT EXISTS `mojeksiazki` DEFAULT CHARACTER SET utf8 COLLATE utf8_polish_ci ;
USE `mojeksiazki` ;

-- -----------------------------------------------------
-- Table `mojeksiazki`.`ksiazka`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `mojeksiazki`.`ksiazka` (
  `ksiazka_id` INT NOT NULL AUTO_INCREMENT ,
  `tytul` VARCHAR(128) NULL ,
  `rokwydania` INT NULL ,
  `miesiacwydania` INT NULL ,
  `dzienwydania` INT NULL ,
  `wydanie` VARCHAR(2) NULL ,
  `liczbastron` INT NULL ,
  `format` VARCHAR(15) NULL ,
  `oprawa` VARCHAR(45) NULL ,
  `zawiera_dvd` TINYINT(1)  NULL ,
  `ksiazkawkolorze` TINYINT(1)  NULL ,
  `zawiera_cdrom` TINYINT(1)  NULL ,
  `isbn` VARCHAR(45) NULL ,
  `cena` VARCHAR(45) NULL ,
  `img_okladka` VARCHAR(45) NULL ,
  `url_stronadomowa` VARCHAR(128) NULL ,
  `url_ksiazkawhelionie` VARCHAR(128) NULL ,
  `url_dodajdokoszyka` VARCHAR(128) NULL ,
  `katalog` INT NULL ,
  `ident` VARCHAR(45) NULL ,
  `wydawnictwo` VARCHAR(45) NULL ,
  `miasto` VARCHAR(45) NULL ,
  PRIMARY KEY (`ksiazka_id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mojeksiazki`.`user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `mojeksiazki`.`user` (
  `user_id` INT NOT NULL AUTO_INCREMENT ,
  `username` VARCHAR(128) NOT NULL ,
  `password` VARCHAR(128) NULL ,
  `salt` VARCHAR(128) NULL ,
  `email` VARCHAR(128) NULL ,
  PRIMARY KEY (`user_id`) ,
  UNIQUE INDEX `username_UNIQUE` (`username` ASC) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mojeksiazki`.`action`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `mojeksiazki`.`action` (
  `action_id` INT NOT NULL AUTO_INCREMENT ,
  `module` VARCHAR(45) NULL ,
  `controller` VARCHAR(45) NULL ,
  `action` VARCHAR(45) NULL ,
  `is_secure` TINYINT(1)  NULL DEFAULT 0 ,
  PRIMARY KEY (`action_id`) )
ENGINE = InnoDB;


-- -----------------------------------------------------
-- Table `mojeksiazki`.`action_has_user`
-- -----------------------------------------------------
CREATE  TABLE IF NOT EXISTS `mojeksiazki`.`action_has_user` (
  `action_id` INT NOT NULL ,
  `user_id` INT NOT NULL ,
  PRIMARY KEY (`action_id`, `user_id`) ,
  INDEX `fk_action_has_user_action` (`action_id` ASC) ,
  INDEX `fk_action_has_user_user1` (`user_id` ASC) ,
  CONSTRAINT `fk_action_has_user_action`
    FOREIGN KEY (`action_id` )
    REFERENCES `mojeksiazki`.`action` (`action_id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION,
  CONSTRAINT `fk_action_has_user_user1`
    FOREIGN KEY (`user_id` )
    REFERENCES `mojeksiazki`.`user` (`user_id` )
    ON DELETE NO ACTION
    ON UPDATE NO ACTION)
ENGINE = InnoDB;



SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;


grant all on `mojeksiazki`.* to redaktor@localhost identified by 'tajnehaslo';
flush privileges;