#!/usr/bin/env python3
# Zmodyfikowany przykład countasync.py z https://realpython.com/async-io-python/#the-asyncio-package-and-asyncawait

import asyncio

async def count():
    print("Jeden")
    await asyncio.sleep(1)
    print("Dwa")

async def main():
    await asyncio.gather(count(), count(), count())

if __name__ == "__main__":
    import time
    s = time.perf_counter()
    asyncio.run(main())
    elapsed = time.perf_counter() - s
    print(f"Wykonano w czasie {elapsed:0.2f} sekund.")

