#!/usr/bin/env python3

import matplotlib.pyplot as plt
import matplotlib.dates as dates

x_time = []
out_octets = []
out_packets = []
in_octets = []
in_packets = []

with open('results.txt', 'r') as f:
    for line in f.readlines():
        # Wywołanie eval(line) wczytuje każdy wiersz tekstu jako słownik, a nie jako łańcuch znaków
        line = eval(line)
        # Konwertujemy na wewnętrzną liczbę zmiennoprzecinkową
        x_time.append(dates.datestr2num(line['Time']))
        out_packets.append(line['Gig0-0_Out_uPackets'])
        out_octets.append(line['Gig0-0_Out_Octet'])
        in_packets.append(line['Gig0-0_In_uPackets'])
        in_octets.append(line['Gig0-0_In_Octet'])

plt.subplots_adjust(bottom=0.3)
plt.xticks(rotation=80)

# Używamy plot_date, by wyświetlić dane na osi X w formacie daty
plt.plot_date(x_time, out_packets, '-', label='Out Packets')
plt.plot_date(x_time, out_octets, '-', label='Out Octets')
plt.plot_date(x_time, in_packets, '-', label='In Packets')
plt.plot_date(x_time, in_octets, '-', label='In Octets')

plt.title('Router1 G0/0')
plt.legend(loc='upper left')
plt.grid(True)
plt.xlabel('Time in UTC')
plt.ylabel('Values')
plt.savefig('matplotlib_2_result.png')
plt.show()


