#!/usr/bin/env python3

import matplotlib.pyplot as plt
import matplotlib.dates as dates

x_time = []
y_value = []

with open('results.txt', 'r') as f:
    for line in f.readlines():
        # Wywołanie eval(line) wczytuje każdy wiersz tekstu jako słownik, a nie jako łańcuch znaków
        line = eval(line)
        # Konwertujemy na wewnętrzną liczbę zmiennoprzecinkową
        x_time.append(dates.datestr2num(line['Time']))
        y_value.append(line['Gig0-0_Out_uPackets'])

plt.subplots_adjust(bottom=0.3)
plt.xticks(rotation=80)

# Używamy plot_date, by wyświetlić dane na osi X w formacie daty
plt.plot_date(x_time, y_value)
plt.title('Router1 G0/0')
plt.xlabel('Time in UTC')
plt.ylabel('Output Unicast Packets')
plt.savefig('matplotlib_1_result.png')
plt.show()


