#!/usr/bin/env python3

from ncclient import manager
from ncclient.xml_ import new_ele, sub_ele

conn = manager.connect(host='192.168.2.70', port='830', username='juniper', password='juniper!', timeout=10, device_params={'name':'junos'}, hostkey_verify=False)

# zablokowanie konfiguracji i wprowadzenie w niej zmian
conn.lock()

# zbudowanie konfiguracji
config = new_ele('system')
sub_ele(config, 'host-name').text = 'master'
sub_ele(config, 'domain-name').text = 'python'

# wysłanie, walidacja, i zatwierdzenie konfiguracji
conn.load_configuration(config=config)
conn.validate()
commit_config = conn.commit()
print(commit_config.tostring)

# odblokowanie konfiguracji
conn.unlock()

# zamknięcie sesji
conn.close_session()


