# Wczytywanie i eksploracja danych
library(tidyverse)

# Wczytywanie danych z plików Excela
library(readxl)

# Obliczanie statystyk podsumowujących
library(psych)

# Zapis danych w formacie Excela
library(writexl)

my_number <- 8.2
sqrt(my_number)

my_char <- 'Witaj, świecie'
toupper(my_char)

is.vector(my_number)

length(my_number)

my_numbers <- c(5, 8, 2, 7)

is.vector(my_numbers)
str(my_numbers)
length(my_numbers)

sqrt(my_numbers)

roster_names <- c('Jack', 'Jill', 'Billy', 'Susie', 'Johnny')
toupper(roster_names)

my_vec <- c('A', 2, 'C')
my_vec

str(my_vec)

# Pobieranie trzeciego elementu wektora roster_names
roster_names[3]

# Pobieranie pierwszych trzech elementów z wektora
roster_names[1:3]

# Pobieranie wszystkich elementów, począwszy od drugiego aż do ostatniego
roster_names[2:length(roster_names)]


# Pobieranie drugiego i piątego elementu
roster_names[c(2, 5)]


roster <- data.frame(
  imię = c('Jack', 'Jill', 'Billy', 'Susie', 'Johnny'),
  wzrost = c(182, 165, 172, 175, 168),
  ranny = c(FALSE, TRUE, FALSE, FALSE, TRUE))
roster


data()

head(iris)

is.data.frame(iris)

str(iris)

data(package = 'psych')
data('sat.act')
str(sat.act)



getwd()


file.exists('plik-testowy.csv')

file.exists('folder-testowy/plik-testowy.csv')

# TRUE jedynie w przypadku, gdy plik znajduje się o jeden folder wyżej w ścieżce
file.exists('../plik-testowy.csv')

read_csv('dane/star/okręgi.csv')

districts <- read_csv("dane/star/okręgi.csv")
districts


star <- read_xlsx("dane/star/star.xlsx")
head(star)

View(star)

glimpse(star)

summary(star)

describe(star)


# Trzeci wiersz i druga kolumna ramki danych
roster[3, 2]

# Wiersze od drugiego do czwartego, kolumny od pierwszej do trzeciej
roster[2:4, 1:3]

# Tylko drugi i trzeci wiersz
roster[2:3,]


# Tylko pierwsza i trzecia kolumna
roster[, c(1,3)]


roster$wzrost

is.vector(roster$wzrost)

# Zapis ramki danych roster w pliku .csv
write_csv(roster, 'dane-wyjściowe/roster-r.csv')


# Zapis ramki danych roster w arkuszu Excela
write_xlsx(roster, 'dane-wyjściowe/roster-r.xlsx')
