#install.packages('DAAG')
library(DAAG)
library(tidyverse)
#install.packages('tidymodels')
library(tidymodels)
library(readxl)
ais <- read_excel("dane/ais/ais.xlsx")

# 1. Wizualizacja rcc w zależności od płci
ggplot(data = ais, aes(x = płeć, y = rcc))+
  geom_boxplot()


ggplot(data = ais, aes(x = rcc))+
         geom_histogram()+
         facet_wrap(~ płeć)

# 2. Czy istnieje znacząca różnica w liczbie czerwonych krwinek między tymi grupami?
t.test(rcc ~ płeć, data=ais)
# Tak, istnieje statystycznie istotna różnica

# 3. Macierz korelacji odpowiednich zmiennych
ais %>% 
  select(-c(płeć, sport)) %>% 
  cor()

# Sporo wykresów, może warto wybrać jedynie niektóre z nich 
ais %>% 
  select(-c(płeć, sport)) %>% 
  pairs()


# 4. # Wizualizacja związku wzrostu i wagi
ggplot(data = ais, aes(x = wzrost,y = waga))+
  geom_point()


# 5. # Regresja: waga w zależności od wzrostu
ais_reg <- lm(waga ~ wzrost, data = ais)
summary(ais_reg)

# Tak, istnieje statystycznie istotny związek
# waga = -126 + 1.11 * wzrost
# Waga wyjaśnia około 61% wariancji wzrostu

# Bonus: wizualizacja regresji
ggplot(data = ais, aes(x = wzrost,y = waga))+
  geom_point()+
  geom_smooth(method = lm)


# 5. Podział danych na zbiór uczący i testowy oraz walidacja modelu
set.seed(1234)
ais_split <- initial_split(ais)
ais_train <- training(ais_split)
ais_test <- testing(ais_split)


dim(ais_train)
dim(ais_test)
# W tych próbkach mogą wystąpić problemy z reprezentatywnością niskich wartości. Zachowaj ostrożność 


# Określenie rodzaju modelu
lm_spec <- linear_reg()

# Dopasowanie modelu do danych
lm_fit <- lm_spec %>%
  fit(wzrost ~ waga, data = ais)

ais_pred <- lm_fit %>% 
  predict(new_data = ais_test) %>% 
  bind_cols(ais_test)


# Obliczanie wartości R-kwadrat
rsq(data = ais_pred, truth = wzrost, estimate = .pred)

# Obliczanie rmse
rmse(data = ais_pred, truth = wzrost, estimate = .pred)
