<?php

class AdminController extends Controller
{
    public function actionWpisy()
    {
        $this->pageTitle = 'Wpisy';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $WpisDodany = false;

		$ModelKategorie = new BlogKategorie;

        $ModelWpisy = new BlogWpisy;

        if(isset($_POST['BlogWpisy']))
        {
            $ModelWpisy->attributes=$_POST['BlogWpisy'];

            $ModelWpisy->wpis_data = date('Y-m-d');

			if($ModelWpisy->validate())
			{
            	$ModelWpisy->DodajNowyWpis();

                $WpisDodany = true;
                $ModelWpisy->wpis_tytul = '';
                $ModelWpisy->wpis_tresc = '';
                $ModelWpisy->wpis_kategoria = '';
                $ModelWpisy->wpis_data = '';
            }
        }

		$IloscWpisow = $ModelWpisy->LiczWszystkieWpisy();

		$Strony = new CPagination(intval($IloscWpisow));
		$Strony->pageSize = 10;

		$Dane = $ModelWpisy->WybierzWpisy($Strony->pageSize, $Strony->currentPage);

         $this->render('wpisy',array(
            'Dane' => $Dane,
            'Strony' => $Strony,
            'WpisDodany' => $WpisDodany,
            'ModelWpisy' => $ModelWpisy,
            'ModelKategorie' => $ModelKategorie,


        ));
    }

    public function actionWpisUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

		$ModelWpisy = new BlogWpisy;

        $ModelWpisy->UsunWpis($id);

        $this->redirect(array('admin/wpisy'));
    }

    public function actionWpisAktualizuj($id)
    {
        $this->pageTitle = 'Edycja wpisu';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        $WpisZaktualizowany = false;

		$ModelWpisy = new BlogWpisy;

		$ModelKategorie = new BlogKategorie;

        if(isset($_POST['BlogWpisy']))
        {
            $ModelWpisy->attributes = $_POST['BlogWpisy'];

            if($ModelWpisy->validate())
            {
				$ModelWpisy->AktualizujWpis($id);
                $WpisZaktualizowany = true;
            }
        }
        else
        {
			$Dane = $ModelWpisy->PobierzWpis($id);

			foreach($Dane as $DaneWpisu)
			{
				$ModelWpisy->wpis_tytul = $DaneWpisu['wpis_tytul'];
				$ModelWpisy->wpis_tresc = $DaneWpisu['wpis_tresc'];
				$ModelWpisy->wpis_kategoria = $DaneWpisu['wpis_kategoria'];
			}
		}

        $this->render('wpisaktualizuj',array(
            'ModelWpisy' => $ModelWpisy,
            'WpisZaktualizowany' => $WpisZaktualizowany,
            'ModelKategorie' => $ModelKategorie,
        ));
    }

    public function actionKategorie()
    {
        $this->pageTitle = 'Kategorie';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $KategoriaDodana = false;

        $ModelKategorie = new BlogKategorie;

        if(isset($_POST['BlogKategorie']))
        {
            $ModelKategorie->attributes=$_POST['BlogKategorie'];

			if($ModelKategorie->validate())
			{
				$ModelKategorie->DodajKategorie();

            	$KategoriaDodana = true;
            	$ModelKategorie->kategoria_nazwa = '';
			}
        }

		$DaneKategorii = $ModelKategorie->PobierzKategorie();

         $this->render('kategorie',array(
            'Dane' => $DaneKategorii,
            'KategoriaDodana' => $KategoriaDodana,
            'ModelKategorie' => $ModelKategorie
        ));
    }

    public function actionKategorieUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

		$ModelKategorie = new BlogKategorie;

        $ModelKategorie->UsunKategorie($id);

        $this->redirect(array('admin/kategorie'));
    }

    public function actionKategorieAktualizuj($id)
    {
        $this->pageTitle = 'Edycja kategorii';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

        $KategoriaZaktualizowana = false;

		$ModelKategorie = new BlogKategorie;

        if(isset($_POST['BlogKategorie']))
        {
            $ModelKategorie->attributes = $_POST['BlogKategorie'];

            if($ModelKategorie->validate())
            {
				$ModelKategorie->ZapiszKategorie($id);

                $KategoriaZaktualizowana = true;
            }
        }
        else
        {
			$Dane = $ModelKategorie->PobierzJednaKategorie($id);

			foreach($Dane as $DaneFormularza)
			{
				$ModelKategorie->kategoria_nazwa = $DaneFormularza['kategoria_nazwa'];
			}
		}

        $this->render('kategorieaktualizuj',array(
            'ModelKategorie' => $ModelKategorie,
            'KategoriaZaktualizowana' => $KategoriaZaktualizowana,
        ));
    }

    public function actionKomentarze()
    {
        $this->pageTitle = 'Komentarze';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $ModelKomentarze = new BlogKomentarze;

		$IloscWpisow = $ModelKomentarze->LiczWszystkieKomentarze();

		$Strony = new CPagination(intval($IloscWpisow));
		$Strony->pageSize = 10;

		$DaneWpisow = $ModelKomentarze->WybierzKomentarze($Strony->pageSize, $Strony->currentPage);

		$this->render('komentarze',
			array(
				'Dane' => $DaneWpisow,
				'Strony' => $Strony,
				)
		);
    }

    public function actionKomentarzUsun($id)
    {
        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        if(!is_numeric($id))
        {
            exit;
        }

		$ModelKomentarze = new BlogKomentarze;

        $ModelKomentarze->UsunKomentarz($id);

        $this->redirect(array('admin/komentarze'));
    }

    public function actionHaslo()
    {
        $this->pageTitle = 'Zmiana hasła';

        if(Yii::app()->session['zalogowany'] != 'tak'){ $this->redirect(array('zaloguj/index')); }

        $BladPrzyZmianie = false;

        $ModelHaslo = new BlogZmianaHasla;

        if(isset($_POST['BlogZmianaHasla']))
        {
            $ModelHaslo->attributes=$_POST['BlogZmianaHasla'];

            if($ModelHaslo->validate())
            {
				$WybierzHaslo = $ModelHaslo->WybierzUzytkownika(Yii::app()->session['root']);

                foreach($WybierzHaslo as $RezultatWiersz)
                {
                     $StareHaslo = $RezultatWiersz['uzytkownik_haslo'];
                }

                if($StareHaslo == md5($ModelHaslo->uzytkownik_haslo))
                {
                    if($ModelHaslo->uzytkownik_nowehaslo == $ModelHaslo->uzytkownik_nowehaslo2)
                    {
						$ModelHaslo->AktualizujHaslo(Yii::app()->session['root']);

						$ModelHaslo->uzytkownik_haslo = '';
						$ModelHaslo->uzytkownik_nowehaslo = '';
						$ModelHaslo->uzytkownik_nowehaslo2 = '';

                        $BladPrzyZmianie = 'brak_bledow';
                    }
                    else
                    {
                        $BladPrzyZmianie = 'hasla_nie_pasuja';
                    }
                }
                else
                {
                    $BladPrzyZmianie = 'zle_haslo';
                }
            }
        }

        $this->render('haslo',
                    array(
                        'ModelHaslo'=>$ModelHaslo,
                        'BladPrzyZmianie' => $BladPrzyZmianie
                        )
                    );
    }
}

?>