<?php

class BlogWpisy extends CFormModel
{
	public $wpis_tytul;
	public $wpis_tresc;
	public $wpis_kategoria;
	public $wpis_data;

	public function rules()
	{
		return array(
			array('wpis_tytul, wpis_tresc, wpis_kategoria', 'required'),
			array('wpis_kategoria', 'numerical', 'integerOnly'=>true),
			array('wpis_tytul', 'length', 'max'=>65),
		);
	}

	public function attributeLabels()
	{
		return array(
			'wpis_id' => 'ID',
			'wpis_tytul' => 'Tytuł',
			'wpis_tresc' => 'Treść',
			'wpis_kategoria' => 'Kategoria',
			'wpis_data' => 'Data',
		);
	}

	public function LiczWszystkieWpisy()
	{
		$LiczWpisy =  Yii::app()->db->createCommand('SELECT count(wpis_id) AS IleWpisow FROM blog_wpisy');
		$IloscWpisow = $LiczWpisy->queryScalar();

		return $IloscWpisow;
	}

	public function WybierzWpisy($LimitNaStrone = 10, $ObecnaStrona = 1)
	{
		$WybierzWpisy = Yii::app()->db->createCommand('SELECT * FROM blog_wpisy ORDER BY wpis_id DESC LIMIT :ZacznijOd , :UstawLimit');
		$WybierzWpisy->bindValue(':ZacznijOd', ($ObecnaStrona * $LimitNaStrone), PDO::PARAM_INT);
		$WybierzWpisy->bindValue(':UstawLimit', $LimitNaStrone, PDO::PARAM_INT);

		$DaneWpisow = $WybierzWpisy->queryAll();

		return $DaneWpisow;
	}

	public function LiczWpisyKategoria($id)
	{
		$LiczWpisy =  Yii::app()->db->createCommand('SELECT count(wpis_id) AS IleWpisow FROM blog_wpisy WHERE wpis_kategoria = :IdKategorii');
		$LiczWpisy->bindValue(':IdKategorii', $id, PDO::PARAM_INT);
		$IloscWpisow = $LiczWpisy->queryScalar();

		return $IloscWpisow;
	}

	public function WybierzWpisyKategoria($id, $LimitNaStrone, $ObecnaStrona)
	{
		$WybierzWpisy =  Yii::app()->db->createCommand('SELECT * FROM blog_wpisy WHERE wpis_kategoria = :IdKategorii ORDER BY wpis_id DESC LIMIT :ZacznijOd , :UstawLimit');
		$WybierzWpisy->bindValue(':IdKategorii', $id, PDO::PARAM_INT);
		$WybierzWpisy->bindValue(':ZacznijOd', ($ObecnaStrona * $LimitNaStrone), PDO::PARAM_INT);
		$WybierzWpisy->bindValue(':UstawLimit', $LimitNaStrone, PDO::PARAM_INT);
		$DaneWpisow = $WybierzWpisy->queryAll();

		return $DaneWpisow;
	}

	public function PobierzWpis($id)
	{
		$WybierzWpisy =  Yii::app()->db->createCommand('SELECT * FROM blog_wpisy WHERE wpis_id = :IdWpisu');
		$WybierzWpisy->bindValue(':IdWpisu', $id, PDO::PARAM_INT);
		$DaneWpisow = $WybierzWpisy->queryAll();

		return $DaneWpisow;
	}

	public function DodajNowyWpis()
	{
		$DodajWpis =  Yii::app()->db->createCommand('INSERT INTO blog_wpisy
		(wpis_tytul,wpis_tresc,wpis_kategoria,wpis_data)
		VALUES
		(
		:WpisTytul,
		:WpisTresc,
		:WpisKategoria,
		:WpisData
		)
		');
		$DodajWpis->bindValue(':WpisTytul', $this->wpis_tytul, PDO::PARAM_STR);
		$DodajWpis->bindValue(':WpisTresc', $this->wpis_tresc, PDO::PARAM_STR);
		$DodajWpis->bindValue(':WpisKategoria', $this->wpis_kategoria, PDO::PARAM_INT);
		$DodajWpis->bindValue(':WpisData', $this->wpis_data, PDO::PARAM_STR);
		$DodajWpis->execute();
	}

	public function UsunWpis($id)
	{
		$UsunWpis =  Yii::app()->db->createCommand('DELETE FROM blog_wpisy WHERE wpis_id = :IdWpisu');
		$UsunWpis->bindValue(':IdWpisu', $id, PDO::PARAM_INT);
		$UsunWpis->execute();
	}

	public function AktualizujWpis($id)
	{
		$DodajWpis =  Yii::app()->db->createCommand('UPDATE blog_wpisy
		SET
		wpis_tytul = :WpisTytul,
		wpis_tresc = :WpisTresc,
		wpis_kategoria = :WpisKategoria
		WHERE
		wpis_id = :WpisId
		');
		$DodajWpis->bindValue(':WpisTytul', $this->wpis_tytul, PDO::PARAM_STR);
		$DodajWpis->bindValue(':WpisTresc', $this->wpis_tresc, PDO::PARAM_STR);
		$DodajWpis->bindValue(':WpisKategoria', $this->wpis_kategoria, PDO::PARAM_INT);
		$DodajWpis->bindValue(':WpisId', $id, PDO::PARAM_INT);
		$DodajWpis->execute();
	}
}

?>