<?php

class BlogController extends Controller
{
	public function actionIndex()
	{
	   $this->pageTitle = 'Strona główna';
       
        $ModelKategorie = BlogKategorie::model()->findAll();
       
        $Kryteria = new CDbCriteria(
                                    array(
                                        'order' => 'wpis_id DESC'
                                        )
                                    );
                                    
        $Ile = BlogWpisy::model()->count($Kryteria);
        
        $Strony = new CPagination($Ile);
        
        $Strony->pageSize = 10;
        $Strony->applyLimit($Kryteria);
        
        $Model = BlogWpisy::model()->findAll($Kryteria);
        
        $this->render('index', 
            array(
                'ModelKategorie' => $ModelKategorie,
                'Model' => $Model,
                'Strony' => $Strony,
                )
            );
	}
    
    public function actionKategoria($id)
	{
        if(!is_numeric($id))
        {
            exit;
        }

        $Kryteria = new CDbCriteria(
                                    array(
                                        'condition' => 'kategoria_id = :IdKategorii', 
                                        'params' => array(':IdKategorii' => $id),
                                        )
                                    );
                                    
        $ModelKategorie = BlogKategorie::model()->findAll($Kryteria);
       
        foreach($ModelKategorie as $Kategoria)
        {
            $this->pageTitle = 'Kategoria: '.$Kategoria->kategoria_nazwa;
        }
        
        $Kryteria = new CDbCriteria(
                                    array(
                                        'condition' => 'wpis_kategoria = :IdKategorii', 
                                        'params' => array(':IdKategorii' => $id),
                                        'order' => 'wpis_id DESC'
                                        )
                                    );
                                    
        $Ile = BlogWpisy::model()->count($Kryteria);
        
        $Strony = new CPagination($Ile);
        
        $Strony->pageSize = 10;
        $Strony->applyLimit($Kryteria);
        
        $Model = BlogWpisy::model()->findAll($Kryteria);
        
        $this->render('kategoria', 
            array(
                'Model' => $Model,
                'Strony' => $Strony,
                )
            );
	}

	public function actionWpis($id)
	{
        if(!is_numeric($id))
        {
            exit;
        }
        
        $KomentarzDodany = false;

        $ModelKategorie = BlogKategorie::model()->findAll();
        
        $Model = BlogWpisy::model()->findAll('wpis_id=:IdWpisu', array(':IdWpisu'=>$id));
        
        foreach($Model as $Wpis)
        {
            $this->pageTitle = $Wpis->wpis_tytul;
        }
        
        $ModelKomentarz = new BlogKomentarze;

        if(isset($_POST['BlogKomentarze']))
        {
            $ModelKomentarz->attributes=$_POST['BlogKomentarze'];
            
            $ModelKomentarz->komentarz_wpis_id = $id;
            $ModelKomentarz->komentarz_data = date('Y-m-d');
            
            if($ModelKomentarz->validate())
            {
                $ModelKomentarz->save();
                
                $ModelKomentarz->komentarz_wpis_id = '';
                $ModelKomentarz->komentarz_uzytkownik = '';
                $ModelKomentarz->komentarz_tresc = '';
                $ModelKomentarz->komentarz_data = '';
                
                $KomentarzDodany = true;
            }
        }
        
        $Kryteria = new CDbCriteria(
                                    array(
                                        'condition' => 'komentarz_wpis_id=:IdWpisu', 
                                        'params' => array(':IdWpisu'=>$id),
                                        'order' => 'komentarz_id DESC'
                                        )
                                    );
                                    
        $ModelPokazKomentarze = BlogKomentarze::model()->findAll($Kryteria);
        
		$this->render('wpis',
            array(
                'ModelKategorie' => $ModelKategorie,
                'Model' => $Model,
                'ModelKomentarz' => $ModelKomentarz,
                'KomentarzDodany' => $KomentarzDodany,
                'ModelPokazKomentarze' => $ModelPokazKomentarze,
                )
            );
	}
}