<?php

echo '<h1>Wpisy</h1>';

$this->widget('zii.widgets.grid.CGridView', array(
    'id'=>'blog-kategorie-grid',
    'dataProvider'=>$Dane,
    'columns'=>array(
        'wpis_id',
        'wpis_tytul',
        'wpis_data',
        array(
            'class'=>'CButtonColumn',
            'template'=>'{delete}{update}',
            'buttons'=>array
            (
                'delete' => array
                (
                    'url'=>'Yii::app()->createUrl("admin/wpisusun/".$data->wpis_id)',
                ),
                
                'update' => array
                (
                    'url'=>'Yii::app()->createUrl("admin/wpisaktualizuj/".$data->wpis_id)',
                ),
            ),
        ),
    ),
)); 

?>

<div class="form">
<h2 class="admin">Dodaj nowy wpis</h2>

<?php $form=$this->beginWidget('CActiveForm', array(
    'id'=>'blog-wpisy-form',
    'enableAjaxValidation'=>false,
)); ?>

    <p class="note">Pola oznaczone <span class="required">*</span> są wymagane.</p>

    <?php echo $form->errorSummary($ModelDodaj); ?>

    <?php
    
    if($WpisDodany)
    {
        echo '<div>Nowy wpis został dodany.</div>';
    }
    
    ?>
    
    <div class="row">
        <?php echo $form->labelEx($ModelDodaj,'wpis_tytul'); ?>
        <?php echo $form->textField($ModelDodaj,'wpis_tytul',array('size'=>60,'maxlength'=>65)); ?>
        <?php echo $form->error($ModelDodaj,'wpis_tytul'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($ModelDodaj,'wpis_tresc'); ?>
        <?php echo $form->textArea($ModelDodaj,'wpis_tresc',array('rows'=>25, 'cols'=>50)); ?>
        <?php echo $form->error($ModelDodaj,'wpis_tresc'); ?>
    </div>

    <div class="row">
        <?php echo $form->labelEx($ModelDodaj,'wpis_kategoria'); ?>
        
        <?php
        echo $form->dropDownList($ModelDodaj, 'wpis_kategoria',
                CHtml::listData(BlogKategorie::model()->findAll(), 'kategoria_id', 'kategoria_nazwa'),
                array('style'=>'width: 400px;')
                );
        ?>
        
        <?php echo $form->error($ModelDodaj,'wpis_kategoria'); ?>
    </div>

    <div class="row buttons">
        <?php echo CHtml::submitButton('Dodaj'); ?>
    </div>

<?php $this->endWidget(); ?>

</div><!-- form -->