#!/usr/bin/perl

use XML::LibXML;

my $parser = New XML::LibXML;
my %nodeTypes = (
       element => 1,        attribute => 2,   text => 3,
       cdatasection => 4,   entityref => 5,   entitynode => 6,
       procinstruc => 7,    comment => 8,     document => 9
                 );

foreach my $fileName ( @ARGV ) {
  my $docRef;
  eval{ $docRef = $parser->parse_file( $fileName ); };
  die( "Bd parsera: $@" ) if( $@ );
  map_proc_to_elems( \&fix_iterms, $docRef );
  open( OUT, ">$fileName" ) or die ( "Nie mona zapisa pliku $fileName" );
  print OUT $docRef->toString();
  close OUT;
}

sub map_proc_to_elems {
  my( $proc, $nodeRef ) = @_;
  my $nodeType = $nodeRef->nodeType;
  if( $nodeType == $nodeTypes{document} ) {
    map_proc_to_elems( $proc, $nodeRef->getDocumentElement );
  } elsif( $nodeType == $nodeTypes{element} ) {
    &$proc( $nodeRef );
    foreach my $childNodeRef ( $nodeRef->getChildnodes ) { 
      map_proc_to_elems( $proc, $childNodeRef );
    }
  }
}
    
sub fix_iterms {
  my $nodeRef = shift;
  return unless( $nodeRef->nodeName eq 'indexterm' );
  my $parentNodeRef = $nodeRef->parentNode;
  return unless( $parentNodeRef->nodeName eq 'title' );
  $parentNodeRef->removeChild( $nodeRef );
  my $ancestorNodeRef = $parentNodeRef->parentNode;
  $ancestorNodeRef->insertAfter( $nodeRef, $parentNodeRef );
}