﻿<?xml version="1.0"?>

<!--
============================================================================
Prosty arkusz transformacji, służący do otrzymywania informacji na podstawie
zestawienia dochodów i wydatków.
============================================================================
-->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">

<xsl:template match="zestawienie-doch-wyd">
  <html>
    <head/>
    <body>
      <h3>
        <xsl:text>Dochody za okres od </xsl:text>
        <xsl:value-of select="child::*[1]/data"/>
        <xsl:text> do </xsl:text>
        <xsl:value-of select="child::*[last()]/data"/>
        <xsl:text>:</xsl:text>
      </h3>
      <xsl:apply-templates select="lokata"/>
      <h3>
        <xsl:text>Wydatki za okres od </xsl:text>
        <xsl:value-of select="child::*[1]/data"/>
        <xsl:text> do </xsl:text>
        <xsl:value-of select="child::*[last()]/data"/>
        <xsl:text>, przedstawione od najwyższej do najniższej kwoty transakcji:</xsl:text>
      </h3>
      <xsl:apply-templates select="opłata">
        <xsl:sort data-type="number" order="descending" select="kwota"/>
      </xsl:apply-templates>
      <h3>Bilans</h3>
      <p>
        <xsl:text>Stan konta na dzień </xsl:text>
        <xsl:value-of select="child::*[last()]/data"/>
        <xsl:text> to </xsl:text>
        <tt><b>
          <xsl:choose>
            <xsl:when test="sum( opłata/kwota ) > sum( lokata/kwota )">
              <font color="red">
                <xsl:value-of select="sum( lokata/kwota )
                                    - sum( opłata/kwota )"/>
                <xsl:text> zł</xsl:text>
              </font>
            </xsl:when>
            <xsl:otherwise>
              <font color="blue">
                <xsl:value-of select="sum( lokata/kwota )
                                    - sum( lokata/kwota )"/>
                <xsl:text> zł</xsl:text>
              </font>
            </xsl:otherwise>
          </xsl:choose>
        </b></tt>
      </p>
      <xsl:if test="sum( opłata/kwota ) > sum( lokata/kwota )">
        <p>
          <font color="red">
            <xsl:text>OSTRZEŻENIE! Szybko zasil konto!</xsl:text>
          </font>
        </p>
      </xsl:if>
    </body>
  </html>
</xsl:template>

<xsl:template match="opłata[@typ='bankomat']">
  <p>
    <xsl:value-of select="position()"/>
    <xsl:text>. W dniu </xsl:text>
    <xsl:value-of select="data"/>
    <xsl:text> użytkownik wypłacił kwotę </xsl:text>
    <tt><b>
      <xsl:value-of select="kwota"/>
      <xsl:text> zł</xsl:text>
    </b></tt>
    <xsl:text> z bankomatu z przeznaczeniem na </xsl:text>
    <xsl:value-of select="opis"/>
    <xsl:text>.</xsl:text>
  </p>
</xsl:template>

<xsl:template match="opłata">
  <p>
    <xsl:value-of select="position()"/>
    <xsl:text>. W dniu </xsl:text>
    <xsl:value-of select="data"/>
    <xsl:text> użytkownik zapłacił kwotę </xsl:text>
    <tt><b>
      <xsl:value-of select="kwota"/>
      <xsl:text> zł</xsl:text>
    </b></tt>
    <xsl:text> dla </xsl:text>
    <i>
      <xsl:value-of select="beneficjent"/>
    </i>
    <xsl:text> za </xsl:text>
    <xsl:value-of select="opis"/>
    <xsl:text>.</xsl:text>
  </p>
</xsl:template>

<xsl:template match="lokata">
  <p>
    <xsl:value-of select="position()"/>
    <xsl:text>. W dniu </xsl:text>
    <xsl:value-of select="data"/>
    <xsl:text> kwota </xsl:text>
    <tt><b>
      <xsl:value-of select="kwota"/>
      <xsl:text> zł</xsl:text>
    </b></tt>
    <xsl:text> została wpłacona na konto użytkownika przez </xsl:text>
    <i>
      <xsl:value-of select="płatnik"/>
    </i>
    <xsl:text>.</xsl:text>
  </p>
</xsl:template>
</xsl:stylesheet>