﻿<xsl:stylesheet
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    version="1.0"
>
  <xsl:output method="xml" encoding="ISO-8859-2"/>

  <!-- Obsługa elementu dokumentu: ustawienie strony HTML -->
  <xsl:template match="podręcznik">
    <html>
      <head><title>Instrukcja użytkownika</title></head>
      <body>
        <h1>Instrukcja użytkownika</h1>
        <xsl:apply-templates/>
      </body>
    </html>
  </xsl:template>

  <!-- Utworzenie listy części -->
  <xsl:template match="lista-części">
    <h2>Części</h2>
    <dl>
      <xsl:apply-templates/>
    </dl>
  </xsl:template>

  <!-- Jedno z zastosowań elementu <część>: pozycja na liście -->
  <xsl:template match="część[@etykieta]">
    <dt>
      <xsl:value-of select="@etykieta"/>
    </dt>
    <dd>
      <xsl:apply-templates/>
    </dd>
  </xsl:template>

  <!-- Kolejne zastosowanie elementu <część>: wygenerowanie nazwy części -->
  <xsl:template match="część[@ref]">
    <xsl:variable name="etykieta">
      <xsl:value-of select="@ref"/>
    </xsl:variable>
    <xsl:value-of select="//część[@etykieta=$etykieta]"/>
    <xsl:text> (Część </xsl:text>
    <xsl:value-of select="@ref"/>
    <xsl:text>)</xsl:text>
  </xsl:template>

  <!-- Określenie listy instrukcji -->
  <xsl:template match="instrukcje">
    <h2>Etapy</h2>
    <ol>
      <xsl:apply-templates/>
    </ol>
  </xsl:template>

  <!-- Obsłużenie każdej pozycji (<etap>) z listy instrukcji -->
  <xsl:template match="etap">
    <li>
      <xsl:apply-templates/>
    </li>
  </xsl:template>

</xsl:stylesheet>