﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html"/>

<xsl:template match="/">
 <html><head><title>Cuda starożytnego świata</title></head>
  <body>
   <h1>Siedem cudów starożytnego świata</h1>

   <h2>Przegląd</h2>
   <table border="1"><tr><th>Nazwa cudu</th><th>Lokalizacja</th><th>Wysokość</th></tr>
    <xsl:apply-templates select="cuda_starozytnosci/cud">
     <xsl:sort select="wysokosc" order="descending" data-type="number" />
    </xsl:apply-templates>
   </table>

   <h2>Historia</h2>
   <xsl:apply-templates select="cuda_starozytnosci/cud/historia">
    <xsl:sort select="rok_wybudowania" order="descending" data-type="number" />
   </xsl:apply-templates>

  </body>
 </html>
</xsl:template>

<xsl:template match="cud">
 <tr>
  <td>
   <a><xsl:attribute name="href">#<xsl:value-of select="nazwa[@jezyk='polski']"/></xsl:attribute>
   <strong><xsl:value-of select="nazwa[@jezyk='polski']"/></strong></a><br/>
   <xsl:apply-templates select="nazwa[@jezyk!='polski']"/>
  </td>
  <td><xsl:value-of select="lokalizacja"/></td>
  <td>
   <xsl:choose>
    <xsl:when test="wysokosc != 0">
     <xsl:value-of select="wysokosc"/>
    </xsl:when>
    <xsl:otherwise>
      nieznana
    </xsl:otherwise>
   </xsl:choose>
  </td>
 </tr>
</xsl:template>
   
<xsl:template match="historia">
 <a><xsl:attribute name="name"><xsl:value-of select="../nazwa[@jezyk='polski']"/></xsl:attribute></a>

  <xsl:value-of select="../nazwa[@jezyk='polski']"/>
 <xsl:apply-templates select="../nazwa[@jezyk!='polski']"/>

<!-- ** XML2e ** -->
<!-- aby śledzić przykład z książki, przeanalizuj poniższy fragment -->
 - obiekt zbudowany w roku <xsl:value-of select="rok_wybudowania"/><xsl:text> </xsl:text><xsl:value-of select="rok_wybudowania/@era"/>
   <xsl:choose>
    <xsl:when test="rok_zniszczenia != 0">
     i zniszczony przez <xsl:value-of select="sposob_zniszczenia"/> w roku <xsl:value-of select="rok_zniszczenia"/> <xsl:text> </xsl:text><xsl:value-of select="rok_zniszczenia/@era"/>
    </xsl:when>
    <xsl:otherwise>
     i stoi do dzisiaj.
    </xsl:otherwise>
   </xsl:choose>
 <br /><br />
</xsl:template>

<xsl:template match="nazwa[@jezyk!='polski']">
 (<em><xsl:value-of select="."/></em>)
</xsl:template>

</xsl:stylesheet>
