﻿<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="2.0">

<xsl:template match="/">
 <html><head><title>Cuda starożytnego świata</title></head>
  <body>
   <h1 align="center">Siedem cudów starożytnego świata</h1>

   <p align="center"><img src="herodotus.jpg" width="120" height="171" /></p>
   <p>Słynny grecki historyk Herodot pisał o siedmiu wielkich osiągnięciach architektonicznych. Choć jego zapiski nie przetrwały, przyczynił się do stworzenia listy opisującej
   <strong>Siedem cudów starożytnego świata</strong>.
   </p>
   
   <p>Te cuda starożytności to 
    <xsl:for-each select="cuda_starozytnosci/cud/nazwa[@jezyk='polski']">
     <xsl:value-of select="."/>
     <xsl:choose>
      <xsl:when test="position()=last()">. </xsl:when>
      <xsl:when test="position()=last()-1"> oraz </xsl:when>
      <xsl:otherwise>, </xsl:otherwise>
     </xsl:choose>
    </xsl:for-each>
    
    Różniły się wysokością w zakresie od 
    <xsl:value-of select="min(cuda_starozytnosci/cud/wysokosc[.!=0])"/> do
    <xsl:value-of select="max(cuda_starozytnosci/cud/wysokosc[.!=0])"/> metrów.
         
<!-- ** XML2e ** -->
<!-- aby śledzić przykład z książki, przeanalizuj poniższy fragment -->
    Spośród tych cudów
    <xsl:value-of select="
		if (every $historia_cudu 
			in (cuda_starozytnosci/cud/historia) 
		    satisfies (exists($historia_cudu/sposob_zniszczenia)) )
		then ('wszystkie')
		else (
			if (some $historia_cudu
				in (cuda_starozytnosci/cud/historia) 
				satisfies (exists($historia_cudu/sposob_zniszczenia)) )
			then ('niektóre')
			else ('żaden')
		)
    " />
	zostały zniszczone.
		
    <xsl:value-of select="count(cuda_starozytnosci/cud/historia/sposob_zniszczenia[. = 'trzęsienie ziemi'])" /> zniszczono przez trzęsienie ziemi, 
    <xsl:value-of select="count(//sposob_zniszczenia[. = 'pożar'])" /> zniszczono przez pożar, a
    <xsl:value-of select="count(//cud) - count(//sposob_zniszczenia)" /> stoi do dzisiaj.
   </p>

   <h2>Przegląd</h2>
   <table border="1"><tr><th>Nazwa cudu</th><th>Miasto</th><th>Kraj</th><th>Lata<br />przetrwane</th><th>Wysokość</th></tr>
    <xsl:apply-templates select="cuda_starozytnosci/cud">
     <xsl:sort select="wysokosc" order="descending" data-type="number" />
    </xsl:apply-templates>
    <tr>
    <td valign="top" align="right" colspan="4">Średnia wysokość: </td>
    <td valign="top"><xsl:value-of select="format-number(avg(cuda_starozytnosci/cud/wysokosc[.!=0]),'##0.0')" /> metrów</td>
    </tr>
   </table>

   <h2>Historia</h2>
   <xsl:apply-templates select="cuda_starozytnosci/cud/historia">
    <xsl:sort select="rok_wybudowania" order="descending" data-type="number" />
   </xsl:apply-templates>

  </body>
 </html>
</xsl:template>

<xsl:template match="cud">
 <tr>
  <td valign="top">
   <a><xsl:attribute name="href">#<xsl:value-of select="nazwa[@jezyk='polski']"/></xsl:attribute>
   <strong><xsl:value-of select="nazwa[@jezyk='polski']"/></strong></a><br/>
   <xsl:apply-templates select="nazwa[@jezyk!='polski']"/>
  </td>
  <td valign="top"><xsl:value-of select="substring-before(lokalizacja, ',')"/></td>
  <td valign="top"><xsl:value-of select="substring-after(lokalizacja, ',')"/></td>
  <td valign="top">
  <xsl:value-of select="

    if (historia/rok_zniszczenia != 0)
		then (
			if (historia/rok_zniszczenia/@era = 'p.n.e.')
				then (historia/rok_wybudowania - historia/rok_zniszczenia)
				else (historia/rok_wybudowania + historia/rok_zniszczenia - 1)
		)
		else (historia/rok_wybudowania + 2008 - 1)
  
  "/>
  </td>
  <td valign="top">
   <xsl:choose>
    <xsl:when test="wysokosc != 0">
     <xsl:value-of select="wysokosc"/> metrów<br />
     (<em><xsl:value-of select="format-number(wysokosc div 0.3048, '##0.0')"/> stóp</em>) 
    </xsl:when>
    <xsl:otherwise>
      nieznana
    </xsl:otherwise>
   </xsl:choose>
  </td>
 </tr>
</xsl:template>
   
<xsl:template match="historia">
 <br />
 <hr />
 <a><xsl:attribute name="name"><xsl:value-of select="../nazwa[@jezyk='polski']"/></xsl:attribute></a>
 <p align="center">
  <strong><xsl:value-of select="upper-case(../nazwa[@jezyk='polski'])"/></strong>
  <br />
  <xsl:apply-templates select="../obrazek_glowny"/>
 </p>
  <xsl:value-of select="../nazwa[@jezyk='polski']"/>
 <xsl:apply-templates select="../nazwa[@jezyk!='polski']"/>
 - obiekt zbudowany w roku <xsl:value-of select="rok_wybudowania"/><xsl:text> </xsl:text><xsl:value-of select="rok_wybudowania/@era"/>
   <xsl:choose>
    <xsl:when test="rok_zniszczenia != 0">
     i zniszczony przez <xsl:value-of select="sposob_zniszczenia"/> w roku <xsl:value-of select="rok_zniszczenia"/> <xsl:text> </xsl:text><xsl:value-of select="rok_zniszczenia/@era"/>
    </xsl:when>
    <xsl:otherwise>
     i stoi do dzisiaj.
    </xsl:otherwise>
   </xsl:choose>
 <xsl:apply-templates select="dzieje"/>
 <br /><br />
</xsl:template>

<xsl:template match="nazwa[@jezyk!='polski']">
 (<em><xsl:value-of select="."/></em>)
</xsl:template>

<xsl:template match="obrazek_glowny">
 <img>
  <xsl:attribute name="src"><xsl:value-of select="./@plik"/></xsl:attribute>
  <xsl:attribute name="width"><xsl:value-of select="ceiling(./@szer div 2)"/></xsl:attribute>
  <xsl:attribute name="height"><xsl:value-of select="ceiling(./@wys div 2)"/></xsl:attribute>
 </img>
</xsl:template>

<xsl:template match="dzieje">
 <xsl:for-each select="text()|./*">
  <xsl:value-of select="."/>
  <xsl:if test="local-name() = 'para'">
   <br /><br />
  </xsl:if>
 </xsl:for-each>
</xsl:template>

</xsl:stylesheet>
