//
//  TrackMyWalks.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using TrackMyWalks.Services;
using TrackMyWalks.ViewModels;
using Xamarin.Forms;

namespace TrackMyWalks
{
	public class App : Application
	{
		public App()
		{
			// sprawdzenie platformy
			if (Device.OS == TargetPlatform.Android)
			{
				MainPage = new SplashPage();
			}
			else
			{
				// gwna strona aplikacji
				var walksPage = new NavigationPage(new WalksPage()
				{
					Title = "Track My Walks"
				});

				var navService = DependencyService.Get<IWalkNavService>() as WalkNavService;

				navService.navigation = walksPage.Navigation;

				navService.RegisterViewMapping(typeof(WalksPageViewModel), typeof(WalksPage));
				navService.RegisterViewMapping(typeof(WalkEntryViewModel), typeof(WalkEntryPage));
				navService.RegisterViewMapping(typeof(WalksTrailViewModel), typeof(WalkTrailPage));
				navService.RegisterViewMapping(typeof(DistTravelledViewModel), typeof(DistanceTravelledPage));

				MainPage = walksPage;
			}
		}

		protected override void OnStart()
    {
        // procedura uruchamiania aplikacji
    }

    protected override void OnSleep()
    {
        // procedura upienia aplikacji
    }

    protected override void OnResume()
    {
        // procedura wznowienia dziaania aplikacji
    }
	}
}