//
//  WalksPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using Xamarin.Forms;
using TrackMyWalks.Models;
using TrackMyWalks.ViewModels;
using TrackMyWalks.Services;

namespace TrackMyWalks
{
	public class WalksPage : ContentPage
	{
		WalksPageViewModel _viewModel
		{
			get { return BindingContext as WalksPageViewModel; }
		}

		public WalksPage()
		{
			var newWalkItem = new ToolbarItem
			{
				Text = "Dodaj szlak"
			};

			// procedura obsugi klikni
			newWalkItem.SetBinding(ToolbarItem.CommandProperty, "CreateNewWalk");

			// dodanie elementu do paska narzdzi
			ToolbarItems.Add(newWalkItem);

			// deklaracja i inicjalizacja kontekstu wizania modelu
			BindingContext = new WalksPageViewModel(DependencyService.Get<IWalkNavService>());

			// definicja szablonu elementu
			var itemTemplate = new DataTemplate(typeof(ImageCell));
			itemTemplate.SetBinding(TextCell.TextProperty, "Title");
			itemTemplate.SetBinding(TextCell.DetailProperty, "Notes");
			itemTemplate.SetBinding(ImageCell.ImageSourceProperty, "ImageUrl");

			var walksList = new ListView
			{
				HasUnevenRows = true,
				ItemTemplate = itemTemplate,
				SeparatorColor = Color.FromHex("#ddd"),
			};

			// wasno wizania dla wpisw
			walksList.SetBinding(ItemsView<Cell>.ItemsSourceProperty, "walkEntries");

			// inicjalizacja procedury obsugi zdarze dotknicia elementu
			walksList.ItemTapped += (object sender, ItemTappedEventArgs e) =>
			{
				var item = (WalkEntries)e.Item;
				if (item == null) return;
				_viewModel.WalkTrailDetails.Execute(item);
				item = null;
			};

			Content = walksList;
		}

		protected override async void OnAppearing()
		{
			base.OnAppearing();

			// inicjalizacja modelu WalksPageViewModel
			if (_viewModel != null)
				await _viewModel.Init();
		}
	}
}