//
//  WalkEntryPage.cs
//  TrackMyWalks
//
// Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using Xamarin.Forms;
using TrackMyWalks.ViewModels;

namespace TrackMyWalks
{
	public class WalkEntryPage : ContentPage
	{
		public WalkEntryPage()
		{
			// tytu strony treci
			Title = "Nowy wpis";

			// deklaracja i inicjalizacja kontekstu wizania modelu
			BindingContext = new WalkEntryViewModel();

			// definicje pl nowego wpisu
			var walkTitle = new EntryCell
			{
				Label = "Tytu:",
				Placeholder = "Nazwa szlaku"
			};

			walkTitle.SetBinding(EntryCell.TextProperty, "Title", BindingMode.TwoWay);

			var walkNotes = new EntryCell
			{
				Label = "Uwag:",
				Placeholder = "Opis"
			};

			walkNotes.SetBinding(EntryCell.TextProperty, "Notes", BindingMode.TwoWay);

			var walkLatitude = new EntryCell
			{
				Label = "Szeroko geograficzna:",
				Placeholder = "Szeroko geograficzna",
				Keyboard = Keyboard.Numeric
			};

			walkLatitude.SetBinding(EntryCell.TextProperty, "Latitude", BindingMode.TwoWay);

			var walkLongitude = new EntryCell
			{
				Label = "Dugo geograficzna:",
				Placeholder = "Dugo geograficzna",
				Keyboard = Keyboard.Numeric
			};

			walkLongitude.SetBinding(EntryCell.TextProperty, "Longitude", BindingMode.TwoWay);

			var walkKilometers = new EntryCell
			{
				Label = "Liczba kilometrw:",
				Placeholder = "Liczba kilometrw",
				Keyboard = Keyboard.Numeric
			};

			walkKilometers.SetBinding(EntryCell.TextProperty, "Kilometers", BindingMode.TwoWay);

			var walkDifficulty = new EntryCell
			{
				Label = "Poziom trudnoci:",
				Placeholder = "Poziom trudnoci szlaku"
			};

			walkDifficulty.SetBinding(EntryCell.TextProperty, "Difficulty", BindingMode.TwoWay);

			var walkImageUrl = new EntryCell
			{
				Label = "URL obrazu:",
				Placeholder = "URL obrazu"
			};

			walkImageUrl.SetBinding(EntryCell.TextProperty, "ImageUrl", BindingMode.TwoWay);

			// definicja TableView 
			Content = new TableView
			{
				Intent = TableIntent.Form,
				Root = new TableRoot
				{
					new TableSection()
					{
						walkTitle,
						walkNotes,
						walkLatitude,
						walkLongitude,
						walkKilometers,
						walkDifficulty,
						walkImageUrl
					}
				}
			};

			var saveWalkItem = new ToolbarItem
			{
				Text = "Zapisz"
			};

			saveWalkItem.SetBinding(MenuItem.CommandProperty,
				"SaveCommand");

			ToolbarItems.Add(saveWalkItem);

			saveWalkItem.Clicked += (sender, e) =>
			{
				Navigation.PopToRootAsync(true);
			};
		}
	}
}