//
//  WalkEntryPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using Xamarin.Forms;
using TrackMyWalks.Models;
using System.Collections.Generic;

namespace TrackMyWalks
{
	public class WalkEntryPage : ContentPage
	{
		public WalkEntryPage()
		{
			// tytu strony
			Title = "Nowy wpis";

			// pola do wypenienia
			var walkTitle = new EntryCell
			{
				Label = "Tytu:",
				Placeholder = "Tytu szlaku"
			};

			var walkNotes = new EntryCell
			{
				Label = "Uwagi:",
				Placeholder = "Opis"
			};

			var walkLatitude = new EntryCell
			{
				Label = "Szeroko geograficzna:",
				Placeholder = "Szeroko",
				Keyboard = Keyboard.Numeric
			};

			var walkLongitude = new EntryCell
			{
				Label = "Dugo geograficzna:",
				Placeholder = "Dugo",
				Keyboard = Keyboard.Numeric
			};

			var walkKilometers = new EntryCell
			{
				Label = "Liczba kilometrw:",
				Placeholder = "Liczba kilometrw",
				Keyboard = Keyboard.Numeric
			};

			var walkDifficulty = new EntryCell
			{
				Label = "Poziom trudnoci:",
				Placeholder = "Poziom trudnoci szlaku"
			};

			var walkImageUrl = new EntryCell
			{
				Label = "ImageUrl:",
				Placeholder = "URL obrazu"
			};

			// definicja widoku TableView 
			Content = new TableView
			{
				Intent = TableIntent.Form,
				Root = new TableRoot
				{
					new TableSection()
					{
						walkTitle,
						walkNotes,
						walkLatitude,
						walkLongitude,
						walkKilometers,
						walkDifficulty,
						walkImageUrl
					}
				}
			};

			var saveWalkItem = new ToolbarItem
			{
				Text = "Zapisz"
			};
			saveWalkItem.Clicked += (sender, e) =>
			{
				Navigation.PopToRootAsync(true);
			};

			ToolbarItems.Add(saveWalkItem);
		}
	}
}