//
//  SplashPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System;
using System.Threading.Tasks;
using TrackMyWalks.Services;
using TrackMyWalks.ViewModels;
using Xamarin.Forms;

namespace TrackMyWalks
{
	public class SplashPage : ContentPage
	{
		public SplashPage()
		{
			AbsoluteLayout splashLayout = new AbsoluteLayout
			{
				HeightRequest = 600
			};

			var image = new Image()
			{
				Source = ImageSource.FromFile("icon.png"),
				Aspect = Aspect.AspectFill,
			};

			AbsoluteLayout.SetLayoutFlags(image, AbsoluteLayoutFlags.All);
			AbsoluteLayout.SetLayoutBounds(image, new Rectangle(0f, 0f, 1f, 1f));

			splashLayout.Children.Add(image);

			Content = new StackLayout()
			{
				Children = { splashLayout }
			};
		}

		protected override async void OnAppearing()
		{
			base.OnAppearing();

			// kilka sekund na wywietlanie ekranu startowego
			await Task.Delay(3000);

			// utworzenie egzemplarza NavigationPage przy uyciu strony gwnej
			var navPage = new NavigationPage(new WalksPage()
			{
				Title = "Track My Walks - Android"
			});

			navPage.BarBackgroundColor = Color.FromHex("#4C5678");
			navPage.BarTextColor = Color.White;

			// deklaracja interfejsu DependencyService
			var navService = DependencyService.Get<IWalkNavService>() as WalkNavService;
			navService.navigation = navPage.Navigation;

			// rejestracja mapowa midzy modelami widokw i widokami (stronami).navService
			navService.RegisterViewMapping(typeof(WalksPageViewModel), typeof(WalksPage));
			navService.RegisterViewMapping(typeof(WalkEntryViewModel), typeof(WalkEntryPage));
			navService.RegisterViewMapping(typeof(WalksTrailViewModel), typeof(WalkTrailPage));
			navService.RegisterViewMapping(typeof(DistTravelledViewModel), typeof(DistanceTravelledPage));

			// ustawienie strony gwnej na stron nawigacji
			Application.Current.MainPage = navPage;
		}
	}
}