//
//  WalkLocationService.cs
//  TrackMyWalks Location Service Class (Android)
//
//  Autor: Steven F. Daniel, 16.09.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System;
using Android.Content;
using Android.Locations;
using TrackMyWalks.Droid;
using TrackMyWalks.Services;
using Xamarin.Forms;

[assembly: Xamarin.Forms.Dependency(typeof(WalkLocationService))]
namespace TrackMyWalks.Droid
{
	// argumenty zdarze zawierajce szeroko i dugo geograficzn
	public class Coordinates : EventArgs, IWalkCoordinates
	{
		public double latitude { get; set; }
		public double longitude { get; set; }
	}

	public class WalkLocationService : Java.Lang.Object, IWalkLocationService, ILocationListener
	{
		LocationManager locationManager;
		Location newLocation;

		// cztery metody interfejsu ILocationListener
		public void OnProviderDisabled(string provider) { }
		public void OnProviderEnabled(string provider) { }
		public void OnStatusChanged(string provider, Availability status, Android.OS.Bundle extras) { }

		// definicja delegatu EventHandler wywoywanego
// w odpowiedzi na uzyskanie danych dotyczcych lokalizacji
		public event EventHandler<IWalkCoordinates> MyLocation;

		// wywoywane przy kadej zmianie lokalizacji
		public void OnLocationChanged(Location location)
		{
			if (location != null)
			{
				// utworzenie egzemplarza LocationEventArgs
				var coords = new Coordinates();

				// przypisanie wartoci Latitude i Longitude uytkownika
				coords.latitude = location.Latitude;
				coords.longitude = location.Longitude;

				// aktualizacja nowej lokalizacji
				newLocation = new Location("Punkt A");
				newLocation.Latitude = coords.latitude;
				newLocation.Longitude = coords.longitude;

				// przekazanie nowej lokalizacji do obiektu
				// procedura obsugi zdarze usugi
				MyLocation(this, coords);
			};
		}

		// Method to call to start getting location
		public void GetMyLocation()
		{
			long minTime = 0;      // czas w milisekundach
			float minDistance = 0; // dystans w metrach

			locationManager = (LocationManager)
				Forms.Context.GetSystemService(Context.LocationService);
			locationManager.RequestLocationUpdates(LocationManager.NetworkProvider,
					minTime,
					minDistance,
					this);
		}

		// obliczanie dystansu dzielcego dwa punkty
		public double GetDistanceTravelled(double lat, double lon)
		{
			Location locationB = new Location("Trail Finish");
			locationB.Latitude = lat;
			locationB.Longitude = lon;

			float distance = newLocation.DistanceTo(locationB) / 1000;
			return distance;
		}

		// zatrzymanie aktualizacji, gdy obiekt zostanie ustawiony na null
		~WalkLocationService()
		{
			locationManager.RemoveUpdates(this);
		}
	}
}