//
//  WalkEntryPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using Xamarin.Forms;
using TrackMyWalks.Models;
using System.Collections.Generic;
using TrackMyWalks.Services;
using TrackMyWalks.ViewModels;

namespace TrackMyWalks
{
	public class WalkEntryPage : ContentPage
	{
		WalkEntryViewModel _viewModel
		{
			get { return BindingContext as WalkEntryViewModel; }
		}

		public WalkEntryPage()
		{
			// tytu strony treci
			Title = "Nowy wpis";

			// deklaracja i inicjalizacja kontekstu wizania modelu
			BindingContext = new WalkEntryViewModel(DependencyService.Get<IWalkNavService>());

			// definicja pl nowego wpisu
			var walkTitle = new EntryCell
			{
				Label = "Tytu:",
				Placeholder = "Tytu szlaku"
			};

			walkTitle.SetBinding(EntryCell.TextProperty, "Title", BindingMode.TwoWay);

			var walkNotes = new EntryCell
			{
				Label = "Uwagi:",
				Placeholder = "Opis"
			};

			walkNotes.SetBinding(EntryCell.TextProperty, "Notes", BindingMode.TwoWay);

			var walkLatitude = new EntryCell
			{
				Label = "Szeroko geograficzna:",
				Placeholder = "Szeroko geograficzna",
				Keyboard = Keyboard.Numeric
			};

			walkLatitude.SetBinding(EntryCell.TextProperty, "Latitude", BindingMode.TwoWay);

			var walkLongitude = new EntryCell
			{
				Label = "Dugo geograficzna:",
				Placeholder = "Dugo geograficzna",
				Keyboard = Keyboard.Numeric
			};

			walkLongitude.SetBinding(EntryCell.TextProperty, "Longitude", BindingMode.TwoWay);

			var walkKilometers = new EntryCell
			{
				Label = "Liczba kilometr:",
				Placeholder = "Liczba kilometr",
				Keyboard = Keyboard.Numeric
			};

			walkKilometers.SetBinding(EntryCell.TextProperty, "Kilometers", BindingMode.TwoWay);

			var walkDifficulty = new EntryCell
			{
				Label = "Poziom trudnoci:",
				Placeholder = "Poziom trudnoci"
			};

			walkDifficulty.SetBinding(EntryCell.TextProperty, "Difficulty", BindingMode.TwoWay);

			var walkImageUrl = new EntryCell
			{
				Label = "URL obrazu:",
				Placeholder = "URL obrazu"
			};

			walkImageUrl.SetBinding(EntryCell.TextProperty, "ImageUrl", BindingMode.TwoWay);

			// definicja widoku 
			Content = new TableView
			{
				Intent = TableIntent.Form,
				Root = new TableRoot
				{
					new TableSection()
					{
						walkTitle,
						walkNotes,
						walkLatitude,
						walkLongitude,
						walkKilometers,
						walkDifficulty,
						walkImageUrl
					}
				}
			};

			var saveWalkItem = new ToolbarItem
			{
				Text = "Zapisz"
			};

			saveWalkItem.SetBinding(ToolbarItem.CommandProperty, "SaveCommand");
			ToolbarItems.Add(saveWalkItem);
		}
	}
}