//
//  WalksPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Collections.Generic;
using Xamarin.Forms;
using TrackMyWalks.Models;
using TrackMyWalks.ViewModels;

namespace TrackMyWalks
{
	public class WalksPage : ContentPage
	{
		public WalksPage()
		{
			var newWalkItem = new ToolbarItem
			{
				Text = "Dodaj wpis"
			};

			// procedura obsugi klikni
			newWalkItem.Clicked += (sender, e) =>
			{
				Navigation.PushAsync(new WalkEntryPage());
			};

			// dodanie elementu do paska narzdzi
			ToolbarItems.Add(newWalkItem);

			// deklaracja i inicjalizacja kontekstu wizania modelu
			BindingContext = new WalksPageViewModel();

			// definicja szablonu elementu
			var itemTemplate = new DataTemplate(typeof(ImageCell));
			itemTemplate.SetBinding(TextCell.TextProperty, "Title");
			itemTemplate.SetBinding(TextCell.DetailProperty, "Notes");
			itemTemplate.SetBinding(ImageCell.ImageSourceProperty, "ImageUrl");

			var walksList = new ListView
			{
				HasUnevenRows = true,
				ItemTemplate = itemTemplate,
				SeparatorColor = Color.FromHex("#ddd"),
			};

			// wasno wizania dla naszych pozycji szlakw
			walksList.SetBinding(ItemsView<Cell>.ItemsSourceProperty, "walkEntries");

			// inicjalizacja procedury obsugi zdarze dotknicia elementu
			walksList.ItemTapped += (object sender, ItemTappedEventArgs e) =>
			{
				var item = (WalkEntries)e.Item;
				if (item == null) return;
				Navigation.PushAsync(new WalkTrailPage(item));
				item = null;
			};

			Content = walksList;
		}
	}
}