//
//  WalksPage.cs
//  TrackMyWalks
//
//  Autor: Steven F. Daniel, 04.08.2016
//  Copyright  2016 GENIESOFT STUDIOS. All rights reserved.
//
using System.Collections.Generic;
using Xamarin.Forms;
using TrackMyWalks.Models;

namespace TrackMyWalks
{
	public class WalksPage : ContentPage
	{
		public WalksPage()
		{
			var newWalkItem = new ToolbarItem
			{
				Text = "Dodaj szlak"
			};
			newWalkItem.Clicked += (sender, e) =>
			{
				Navigation.PushAsync(new WalkEntryPage());
			};

			ToolbarItems.Add(newWalkItem);

			var walkItems = new List<WalkEntries>
			{
				new WalkEntries {
					Title  = "10-milowy szlak wzdu strumienia, Margaret River",
					Notes  = "10-milowy szlak wzdu strumienia zaczyna si w Rotary Park w pobliu Old Kate, czyli " +
							 "starej lokomotywy stojcej w pnocnej czci Margaret River. ",
					Latitude    = -33.9727604,
					Longitude   = 115.0861599,
					Kilometers  = 7.5,
					Distance    = 0,
					Difficulty  = "redni",
					ImageUrl    = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
								  "FullSizeRender1_600_480_c1.jpg"
				},
				new WalkEntries {
					Title  = "cieka Ancient Empire, Dolina Gigantw",
					Notes  = "Ancient Empire to 450-metrowy szlak pord " +
							 "gigantycznych drzew, wrd ktrych znajduj si popularne skate olbrzymy zwane " +
							 "Grandma Tingle.",
					Latitude  = -34.9749188,
					Longitude   = 117.3560796,
					Kilometers = 450,
					Distance   = 0,
					Difficulty = "Trudny",
					ImageUrl   = "http://trailswa.com.au/media/cache/media/images/trails/_mid/" +
								 "Ancient_Empire_534_480_c1.jpg"
				},
			};

			var itemTemplate = new DataTemplate(typeof(ImageCell));
			itemTemplate.SetBinding(TextCell.TextProperty, "Title");
			itemTemplate.SetBinding(TextCell.DetailProperty, "Notes");
			itemTemplate.SetBinding(ImageCell.ImageSourceProperty, "ImageUrl");

			var walksList = new ListView
			{
				HasUnevenRows = true,
				ItemTemplate = itemTemplate,
				ItemsSource = walkItems,
				SeparatorColor = Color.FromHex("#ddd"),
			};

			// konfiguracja procedury obsugi zdarze
			walksList.ItemTapped += (object sender, ItemTappedEventArgs e) =>
			{
				var item = (WalkEntries)e.Item;
				if (item == null) return;
				Navigation.PushAsync(new WalkTrailPage(item));
				item = null;
			};

			Content = walksList;
		}
	}
}