﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Text.RegularExpressions;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace BehaviorTriggers.Behaviors {
   public class EmailValidatorBehavior : Behavior<Entry> {
   const string EmailRegex = 
      @"^(?("")("".+?(?<!\\)""@)|(([0-9a-z]((\.(?!\.))|[-!#\$%&'\*\+/=\?\^`\{\}\|~\w])*)(?<=[0-9a-z])@))" +
      @"(?(\[)(\[(\d{1,3}\.){3}\d{1,3}\])|(([0-9a-z][-\w]*[0-9a-z]*\.)+[a-z0-9][\-a-z0-9]{0,22}[a-z0-9]))$";

   protected override void OnAttachedTo(Entry bindable) {
      bindable.TextChanged += HandleTextChanged;
   }

   void HandleTextChanged(object sender, TextChangedEventArgs e) {
      bool isValid = (Regex.IsMatch(e.NewTextValue, EmailRegex, RegexOptions.IgnoreCase, TimeSpan.FromMilliseconds(250)));
      ((Entry)sender).BackgroundColor = isValid ? Color.Yellow : Color.Red;
      ((Entry)sender).TextColor = Color.Black;
   }

   protected override void OnDetachingFrom(Entry bindable) {
      bindable.TextChanged -= HandleTextChanged;
   }
   }
}
