﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace XamFormsPortable
{
    public class App : Application
    {
        public App()
        {
            // Główna strona aplikacji
            INameService nameService = DependencyService.Get<INameService>();

            Label label = new Label
            {
                XAlign = TextAlignment.Center
            };

            nameService.GetGreeting("Janie", "Kowalski").ContinueWith((antecedent) =>
            {
                label.Text = antecedent.Result;
            }, TaskScheduler.FromCurrentSynchronizationContext());

            MainPage = new ContentPage
            {
                Content = new StackLayout
                {
                    VerticalOptions = LayoutOptions.Center,
                    Children = {
                        label
                    }
                }
            };
        }
    }
}
