﻿using System;
using Xamarin.Forms;
using Xamarin.Forms.Xaml;

namespace XamFormsAddAnimations
{
    [ContentProperty("Source")]
    public class ImageResourceExtension : IMarkupExtension
    {
        public string Source { get; set; }

        public object ProvideValue(IServiceProvider serviceProvider)
        {
            if (Source == null)
                return null;

            // Tutaj za pomocą dowolnej metody dokonaj translacji.
            var imageSource = ImageSource.FromResource(Source);

            return imageSource;
        }
    }
}
