﻿using Plugin.Geolocator.Abstractions;
using System.Threading.Tasks;
using Xamarin.Forms;

namespace XamFormsQueryGps
{
    public class App : Application
    {
        Label gpsLabel;

        public App()
        {
            IGeolocator locator = DependencyService.Get<IGeolocator>();
            locator.DesiredAccuracy = 50;
            locator.AllowsBackgroundUpdates = true;
            locator.StartListening(1, 1, true);
            locator.PositionChanged += LocatorPositionChanged;

            Button button = new Button
            {
                Text = "Odczytaj położenie!"
            };
            button.Clicked += async (sender, e) => await GetCurrentLocationAsync(locator);
            gpsLabel = new Label
            {
                Text = "Współrzędne GPS"
            };

            // Główna strona aplikacji
            MainPage = new ContentPage
            {
                Content = new StackLayout
                {
                    VerticalOptions = LayoutOptions.Center,
                    Children = {
                        gpsLabel,
                        button
                    }
                }
            };
        }

        async Task GetCurrentLocationAsync(IGeolocator locator)
        {
            Position position = await locator.GetPositionAsync(10000);
            PrintPosition(position);
        }

        private void LocatorPositionChanged(object sender, PositionEventArgs e)
        {
            PrintPosition(e.Position);
        }

        private void PrintPosition(Position position)
        {
            gpsLabel.Text = string.Format(
                "Czas: {0} \n" +
                "Szerokość geogr.: {1} \n" +
                "Długość geogr.: {2} \n " +
                "Wysokość: {3} \n" +
                "Dokładność wysokości: {4} \n" +
                "Dokładność: {5} \n " +
                "Kierunek: {6} \n " +
                "Prędkość: {7}",
                position.Timestamp, position.Latitude, position.Longitude,
                position.Altitude, position.AltitudeAccuracy, position.Accuracy,
                position.Heading, position.Speed);
        }
    }
}
