//Rozdział 11.
//Fasada

string url = "http://www.google.com/robots.txt";
var request = WebRequest.Create(url);
request.Credentials = CredentialCache.DefaultCredentials;
var response = request.GetResponse();
var dataStream = response.GetResponseStream();
var reader = new StreamReader(dataStream);
string responseFromServer = reader.ReadToEnd();
Console.WriteLine(responseFromServer);
reader.Close();
response.Close();
new WebClient().DownloadString(url);

//Kwadraty magiczne
public class Generator
{
    private static readonly Random random = new Random();
    public List<int> Generate(int count)
    {
        return Enumerable.Range(0, count)
        .Select(_ => random.Next(1, 6))
        .ToList();
    }
}

public class Splitter
{
    public List<List<int>> Split(List<List<int>> array)
    {
        // Implementację pominięto
    }
}

public class Verifier
{
    public bool Verify(List<List<int>> array)
    {
        if (!array.Any()) return false;
        var expected = array.First().Sum();
        return array.All(t => t.Sum() == expected);
    }
}

public class MagicSquareGenerator
{
    public List<List<int>> Generate(int size)
    {
        var g = new Generator();
        var s = new Splitter();
        var v = new Verifier();
        var square = new List<List<int>>();
        do
        {
            square = new List<List<int>>();
            for (int i = 0; i < size; ++i)
                square.Add(g.Generate(size));
        } while (!v.Verify(s.Split(square)));
        return square;
    }
}

var gen = new MagicSquareGenerator();
var square = gen.Generate(3);

private List<List<int>> generate
    <TGenerator, TSplitter, TVerifier>(int size)
    where TGenerator : Generator, new()
    where TSplitter : Splitter, new()
    where TVerifier : Verifier, new()
{
    var g = new TGenerator();
    var s = new TSplitter();
    var v = new TVerifier();
    // pozostała część kodu bez zmian
}

public List<List<int>> Generate(int size)
{
    return Generate<Generator, Splitter, Verifier>(size);
}

public class UniqueGenerator : Generator
{
    public override List<int> Generate(int count)
    {
        List<int> result;
        do
        {
            result = base.Generate(count);
        } while (result.Distinct().Count() != result.Count);
        return result;
    }
}

var gen = new MagicSquareGenerator();
var square = gen
    .Generate<UniqueGenerator, Splitter, Verifier>(3);



//Budowa terminalu handlowego
//Zaawansowany terminal

public class TableBuffer : IBuffer
{
    private readonly TableColumnSpec[] spec;
    private readonly int totalHeight;
    private readonly List<string[]> buffer;
    private static readonly Point invalidPoint = new Point(-1,-1);
    private readonly short[,] formatBuffer;
    public TableBuffer(TableColumnSpec [] spec, int totalHeight)
    {
        this.spec = spec;
        this.totalHeight = totalHeight;
        buffer = new List<string[]>();
        for (int i = 0; i < (totalHeight - 1); ++i)
        {
            buffer.Add(new string[spec.Length]);
        }
        formatBuffer = new short[spec.Max(s => s.Width),totalHeight];
    }
    public struct TableColumnSpec
    {
        public string Header;
        public int Width;
        public TableColumnAlignment Alignment;
    }
}

// Gdzie jest fasada?
public class Console : Form
{
    private readonly Device device;
    private readonly PresentParameters pp;
    private IList<Viewport> viewports;
    private Size charSize;
    private Size gridSize;
    //tutaj wiele innych pól
}

private Console(bool fullScreen, int charWidth, int charHeight,
    int width, int height, Size? clientSize)
{
    int windowWidth =
    clientSize == null ? charWidth*width : clientSize.Value.Width;
    int windowHeight =
        clientSize == null ? charHeight*height : clientSize.Value.Height;
    // i dużo więcej kodu.

    // tutaj utworzony pojedynczy bufor i wziernik
    // połączone ze sobą i dodane do odpowiednich kolekcji
    // wygenerowane tekstury obrazu
    // obliczony rozmiar siatki w zależności od tego, czy chcemy
    // trybu pełnoekranowego
}

public static Console Create(ConsoleCreationParameters ccp)
{ ... }

public class ConsoleCreationParameters
{
    public Size? ClientSize;
    public int CharacterWidth = 10;
    public int CharacterHeight = 14;
    public int Width = 20;
    public int Height = 30;
    public bool FullScreen;
    public bool CreateDefaultViewAndBuffer = true;
}
 
