package wzorceproj.budowniczy.wakacje;

import java.time.LocalDate;

public class WakacjeObjazdoweBudowniczy extends BudowniczyPlanu {	
	public WakacjeObjazdoweBudowniczy() {
		this.nazwa = "Budowniczy wakacji objazdowych";
	}
	public BudowniczyPlanu dodajZakwaterowanie() {
		this.zakwaterowania.add(new Namiot());
		return this;
	}
	public BudowniczyPlanu dodajZakwaterowanie(String nazwa) {
		this.zakwaterowania.add(new Namiot(nazwa));
		return this;
	}
	public BudowniczyPlanu dodajZakwaterowanie(String nazwa, int rok, int miesiąc, int dzień, int liczbaNocy, int lokalizacja) {
		Rezerwacja reservation = new Rezerwacja();
		reservation.ustawDatęPrzyjazdu(rok, miesiąc, dzień);
		reservation.ustawLiczbęNocy(liczbaNocy);
		
		Namiot tent = new Namiot(nazwa);
		tent.ustawRezerwację(reservation);
		tent.ustawNumerMiejsca(lokalizacja);
		this.zakwaterowania.add(tent);
		return this;
	}
	public BudowniczyPlanu dodajAtrakcję(String event) {
		this.atrakcje.add("Aktywność: " + event);
		return this;
	}
}