package wzorceproj.singleton.fabrykaczekolady;
 
public class CzekoladowyKocioł {
   private boolean pusty;
   private boolean ugotowany;
   private static CzekoladowyKocioł unikalnaInstancja;
  
   private CzekoladowyKocioł() {
      pusty = true;
      ugotowany = false;
   }
  
   public static CzekoladowyKocioł pobierzInstancję() {
      if (unikalnaInstancja == null) {
         System.out.println("Tworzę unikalną instancję klasy CzekoladowyKocioł.");
         unikalnaInstancja = new CzekoladowyKocioł();
      }
      System.out.println("Uruchamiam instancję klasy CzekoladowyKocioł...");
      return unikalnaInstancja;
   }

   public void napełniaj() {
      if (jestPusty()) {
         pusty = false;
         ugotowany = false;
         // Napełniaj bojler mieszanką mleka i czekolady
      }
   }
 
   public void opróżniaj() {
      if (!jestPusty() && jestUgotowany()) {
         // Opróżniaj bojler z ugotowanej mieszanki mleka i czekolady
         pusty = true;
      }
   }
 
   public void gotuj() {
      if (!jestPusty() && !jestUgotowany()) {
         // Gotuj zawartość kotła
         ugotowany = true;
      }
   }
  
   public boolean jestPusty() {
      return pusty;
   }
 
   public boolean jestUgotowany() {
      return ugotowany;
   }
}
