package wzorceproj.posrednik.gumomatmonitor;

public class AutomatSprzedający {
   Stan stanBrakGum;
   Stan stanNieMaMonety;
   Stan stanJestMoneta;
   Stan stanGumaSprzedana;
   Stan stanWygrana;
 
   Stan stan = stanBrakGum;
   int liczba = 0;
    String lokalizacja;
 
   public AutomatSprzedający(String lokalizacja, int liczbaGum) {
      stanBrakGum = new StanBrakGum(this);
      stanNieMaMonety = new StanNieMaMonety(this);
      stanJestMoneta = new StanJestMoneta(this);
      stanGumaSprzedana = new StanGumaSprzedana(this);
      stanWygrana = new StanWygrana(this);

      this.liczba = liczbaGum;
       if (liczbaGum > 0) {
         stan = stanNieMaMonety;
      } 
      this.lokalizacja = lokalizacja;
   }
 
   public void włóżMonetę() {
      stan.włóżMonetę();
   }
 
   public void zwróćMonetę() {
      stan.zwróćMonetę();
   }
 
   public void przekręćGałkę() {
      stan.przekręćGałkę();
      stan.wydaj();
   }

   void ustawStan(Stan stan) {
      this.stan = stan;
   }
 
   void zwolnijGumę() {
      System.out.println("Wypada guma");
      if (liczba != 0) {
         liczba = liczba - 1;
      }
   }
 
   public int pobierzLiczba() {
      return liczba;
   }

   public void napełnij(int liczba) {
      this.liczba = liczba;
      stan = stanNieMaMonety;
   }

    public Stan pobierzStan() {
        return stan;
    }
 
    public String pobierzLokalizacja() {
        return lokalizacja;
    }
 
    public Stan pobierzStanBrakGum() {
        return stanBrakGum;
    }

    public Stan pobierzStanNieMaMonety() {
        return stanNieMaMonety;
    }

    public Stan pobierzStanJestMoneta() {
        return stanJestMoneta;
    }

    public Stan pobierzStanGumaSprzedana() {
        return stanGumaSprzedana;
    }

    public Stan pobierzStanWygrana() {
        return stanWygrana;
    }
 
   public String toString() {
      StringBuffer result = new StringBuffer();
      result.append("\nAutomaty Sprzedające SA");
      result.append("\nWolnostojący automat do sprzedaży gum Gumomat Model #2004 Java\n");
      result.append("Zapas gum: " + liczba );
      result.append("\nBieżący stan automatu: ");
      result.append("Automat znajduje się w stanie " + stan + "\n");
      return result.toString();
   }
}
