package wzorceproj.obserwator.stacjameteoobserwator;

import java.util.Observable;
import java.util.Observer;

public class PrognozaPanel implements Observer, PanelInformacyjny {
	private float bieżąceCiśnienie = 1010.1f;  
	private float poprzednieCiśnienie;

	public PrognozaPanel(Observable obserwowalny) {
		obserwowalny.addObserver(this);
	}

	public void update(Observable obserwowalny, Object arg) {
		if (obserwowalny instanceof DanePogodowe) {
			DanePogodowe danePogodowe = (DanePogodowe)obserwowalny;
			poprzednieCiśnienie = bieżąceCiśnienie;
			bieżąceCiśnienie = danePogodowe.pobierzCiśnienie();
			wyświetl();
		}
	}

	public void wyświetl() {
		System.out.print("Prognoza pogody: ");
		if (bieżąceCiśnienie > poprzednieCiśnienie) {
			System.out.println("Niebawem znacząca poprawa pogody!");
		} else if (bieżąceCiśnienie == poprzednieCiśnienie) {
			System.out.println("Bieżąca pogoda się utrzyma.");
		} else if (bieżąceCiśnienie < poprzednieCiśnienie) {
			System.out.println("Przygotuj się na nadejście chłodniejszych, deszczowych dni!");
		}
	}
}
