package wzorceproj.iterator.laczeniebiznesowobiadmania;

import java.util.Iterator;
  
public class Kelnerka {
   Menu naleśnikarniaMenu;
   Menu obiadowoMenu;
   Menu obiadmaniaMenu;
 
   public Kelnerka(Menu naleśnikarniaMenu, Menu obiadowoMenu, Menu obiadmaniaMenu) {
      this.naleśnikarniaMenu = naleśnikarniaMenu;
      this.obiadowoMenu = obiadowoMenu;
      this.obiadmaniaMenu = obiadmaniaMenu;
   }
 
   public void drukujMenu() {
      Iterator<PozycjaMenu> naleśnikarniaIterator = naleśnikarniaMenu.utwórzIterator();
      Iterator<PozycjaMenu> obiadowoIterator = obiadowoMenu.utwórzIterator();
      Iterator<PozycjaMenu> obiadmaniaIterator = obiadmaniaMenu.utwórzIterator();

      System.out.println("MENU\n----\nŚNIADANIA");
      drukujMenu(naleśnikarniaIterator);

      System.out.println("\nLUNCH");
      drukujMenu(obiadowoIterator);
      
      System.out.println("\nOBIADY");
      drukujMenu(obiadmaniaIterator);
   }
 
   private void drukujMenu(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         System.out.print(pozycjaMenu.pobierzNazwa() + ", ");
         System.out.print(pozycjaMenu.pobierzCena() + " -- ");
         System.out.println(pozycjaMenu.pobierzOpis());
      }
   }
 
   public void drukujMenuWegetariańskie() {
      System.out.println("\nMENU WEGETARIAŃSKIE\n---------------");
      drukujMenuWegetariańskie(naleśnikarniaMenu.utwórzIterator());
      drukujMenuWegetariańskie(obiadowoMenu.utwórzIterator());
      drukujMenuWegetariańskie(obiadmaniaMenu.utwórzIterator());
   }
 
   public boolean czyJestWegetariańska(String name) {
      Iterator<PozycjaMenu> naleśnikarniaIterator = naleśnikarniaMenu.utwórzIterator();
      if (czyJestWegetariańska(name, naleśnikarniaIterator)) {
         return true;
      }
      Iterator<PozycjaMenu> obiadowoIterator = obiadowoMenu.utwórzIterator();
      if (czyJestWegetariańska(name, obiadowoIterator)) {
         return true;
      }
      Iterator<PozycjaMenu> obiadmaniaIterator = obiadmaniaMenu.utwórzIterator();
      if (czyJestWegetariańska(name, obiadmaniaIterator)) {
         return true;
      }
      return false;
   }


   private void drukujMenuWegetariańskie(Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         if (pozycjaMenu.czyJestWegetariańska()) {
            System.out.print(pozycjaMenu.pobierzNazwa() + ", ");
            System.out.print(pozycjaMenu.pobierzCena() + " -- ");
            System.out.println(pozycjaMenu.pobierzOpis());
         }
      }
   }

   private boolean czyJestWegetariańska(String nazwa, Iterator<PozycjaMenu> iterator) {
      while (iterator.hasNext()) {
         PozycjaMenu pozycjaMenu = iterator.next();
         if ((pozycjaMenu.pobierzNazwa()).equals(nazwa)) {
            if (pozycjaMenu.czyJestWegetariańska()) {
               return true;
            }
         }
      }
      return false;
   }
}

